/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.security;

import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.security.AuthenticationMethod;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.serialization.SettingsAware;
import org.opensearch.hadoop.util.ObjectUtils;

public abstract class UserProvider
implements SettingsAware {
    protected Settings settings;

    public static UserProvider create(Settings settings) {
        String className = settings.getSecurityUserProviderClass();
        if (className == null) {
            throw new OpenSearchHadoopIllegalArgumentException("Could not locate classname for UserProvider. One must be set with opensearch.security.user.provider.class");
        }
        return (UserProvider)ObjectUtils.instantiate(className, settings);
    }

    protected Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isOpenSearchKerberosEnabled() {
        return this.settings.getSecurityAuthenticationMethod().equals((Object)AuthenticationMethod.KERBEROS);
    }

    public abstract User getUser();
}

