/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opensearch.hadoop.util.OpenSearchMajorVersion;

public class OpenSearchToken {
    private final String name;
    private final String id;
    private final String apiKey;
    private final long expirationTime;
    private final String clusterName;
    private final OpenSearchMajorVersion majorVersion;

    public OpenSearchToken(String name, String id, String apiKey, long expirationTime, String clusterName, OpenSearchMajorVersion majorVersion) {
        this.name = name;
        this.id = id;
        this.apiKey = apiKey;
        this.expirationTime = expirationTime;
        this.clusterName = clusterName;
        this.majorVersion = majorVersion;
    }

    public OpenSearchToken(DataInput inputStream) throws IOException {
        this.name = inputStream.readUTF();
        this.id = inputStream.readUTF();
        this.apiKey = inputStream.readUTF();
        this.expirationTime = inputStream.readLong();
        this.clusterName = inputStream.readUTF();
        this.majorVersion = OpenSearchMajorVersion.parse(inputStream.readUTF());
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public OpenSearchMajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public void writeOut(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.name);
        dataOutput.writeUTF(this.id);
        dataOutput.writeUTF(this.apiKey);
        dataOutput.writeLong(this.expirationTime);
        dataOutput.writeUTF(this.clusterName);
        dataOutput.writeUTF(this.majorVersion.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSearchToken opensearchToken = (OpenSearchToken)o;
        if (this.expirationTime != opensearchToken.expirationTime) {
            return false;
        }
        if (this.name != null ? !this.name.equals(opensearchToken.name) : opensearchToken.name != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(opensearchToken.id) : opensearchToken.id != null) {
            return false;
        }
        if (this.apiKey != null ? !this.apiKey.equals(opensearchToken.apiKey) : opensearchToken.apiKey != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(opensearchToken.clusterName) : opensearchToken.clusterName != null) {
            return false;
        }
        return this.majorVersion != null ? this.majorVersion.equals(opensearchToken.majorVersion) : opensearchToken.majorVersion == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.apiKey != null ? this.apiKey.hashCode() : 0);
        result = 31 * result + (int)(this.expirationTime ^ this.expirationTime >>> 32);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 31 * result + (this.majorVersion != null ? this.majorVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OpenSearchToken{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", apiKey='" + this.apiKey + '\'' + ", expirationTime=" + this.expirationTime + ", clusterName='" + this.clusterName + '\'' + ", majorVersion=" + this.majorVersion + '}';
    }
}

