/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.query;

import org.opensearch.hadoop.rest.query.QueryBuilder;
import org.opensearch.hadoop.serialization.Generator;

public class ConstantScoreQueryBuilder
extends QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    private QueryBuilder filter;
    private float boost = 1.0f;

    public ConstantScoreQueryBuilder filter(QueryBuilder value) {
        if (value == null) {
            throw new IllegalArgumentException("inner clause [filter] cannot be null.");
        }
        this.filter = value;
        return this;
    }

    public ConstantScoreQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantScoreQueryBuilder that = (ConstantScoreQueryBuilder)o;
        if (Float.compare(that.boost, this.boost) != 0) {
            return false;
        }
        return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
    }

    public int hashCode() {
        int result = this.filter != null ? this.filter.hashCode() : 0;
        result = 31 * result + (this.boost != 0.0f ? Float.floatToIntBits(this.boost) : 0);
        return result;
    }

    @Override
    public void toJson(Generator out) {
        if (this.filter == null) {
            throw new IllegalArgumentException("inner clause [filter] cannot be null.");
        }
        out.writeFieldName("constant_score");
        out.writeBeginObject();
        out.writeFieldName("filter");
        out.writeBeginObject();
        this.filter.toJson(out);
        out.writeEndObject();
        out.writeFieldName("boost");
        out.writeNumber(this.boost);
        out.writeEndObject();
    }
}

