/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.pooling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopIllegalStateException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.Request;
import org.opensearch.hadoop.rest.Response;
import org.opensearch.hadoop.rest.SimpleRequest;
import org.opensearch.hadoop.rest.Transport;
import org.opensearch.hadoop.rest.commonshttp.CommonsHttpTransport;
import org.opensearch.hadoop.rest.stats.Stats;
import org.opensearch.hadoop.security.SecureSettings;
import org.opensearch.hadoop.util.unit.TimeValue;

final class TransportPool {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Settings transportSettings;
    private final SecureSettings secureSettings;
    private final String hostName;
    private final String jobPoolingKey;
    private final TimeValue idleTransportTimeout;
    private final SimpleRequest validationRequest = new SimpleRequest(Request.Method.GET, null, "");
    private final Map<PooledTransport, Long> idle;
    private final Map<PooledTransport, Long> leased;

    TransportPool(String jobPoolingKey, String hostName, Settings transportSettings, SecureSettings secureSettings) {
        this.jobPoolingKey = jobPoolingKey;
        this.hostName = hostName;
        this.transportSettings = transportSettings;
        this.secureSettings = secureSettings;
        this.leased = new HashMap<PooledTransport, Long>();
        this.idle = new HashMap<PooledTransport, Long>();
        this.idleTransportTimeout = transportSettings.getTransportPoolingExpirationTimeout();
    }

    String getJobPoolingKey() {
        return this.jobPoolingKey;
    }

    private PooledTransport create() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new pooled CommonsHttpTransport for host [" + this.hostName + "] belonging to job [" + this.jobPoolingKey + "]"));
        }
        return new PooledCommonsHttpTransport(this.transportSettings, this.secureSettings, this.hostName);
    }

    private boolean validate(PooledTransport transport) {
        try {
            Response response = transport.execute(this.validationRequest);
            return response.hasSucceeded();
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Could not validate pooled connection on lease. Releasing pooled connection and trying again...", (Throwable)ioe);
            return false;
        }
    }

    private void release(PooledTransport transport) {
        transport.close();
    }

    synchronized Transport borrowTransport() {
        long now = System.currentTimeMillis();
        ArrayList<PooledTransport> garbageTransports = new ArrayList<PooledTransport>();
        PooledTransport candidate = null;
        for (Map.Entry<PooledTransport, Long> entry : this.idle.entrySet()) {
            PooledTransport transport = entry.getKey();
            if (this.validate(transport)) {
                candidate = transport;
                break;
            }
            garbageTransports.add(transport);
        }
        for (PooledTransport transport : garbageTransports) {
            this.idle.remove(transport);
            this.release(transport);
        }
        if (candidate == null) {
            candidate = this.create();
        } else {
            this.idle.remove(candidate);
        }
        this.leased.put(candidate, now);
        return new LeasedTransport(candidate, this);
    }

    private synchronized void returnTransport(Transport returning) {
        PooledTransport unwrapped;
        long now = System.currentTimeMillis();
        if (returning instanceof LeasedTransport) {
            LeasedTransport leasedTransport = (LeasedTransport)returning;
            unwrapped = leasedTransport.delegate;
        } else if (returning instanceof PooledTransport) {
            unwrapped = (PooledTransport)returning;
        } else {
            throw new OpenSearchHadoopIllegalStateException("Cannot return a non-poolable Transport to the pool");
        }
        if (!this.leased.containsKey(unwrapped)) {
            throw new OpenSearchHadoopIllegalStateException("Cannot return a Transport object to a pool that was not sourced from the pool");
        }
        this.leased.remove(unwrapped);
        this.idle.put(unwrapped, now);
    }

    synchronized int removeOldConnections() {
        long now = System.currentTimeMillis();
        long expirationTime = now - this.idleTransportTimeout.millis();
        ArrayList<PooledTransport> removeFromIdle = new ArrayList<PooledTransport>();
        for (Map.Entry<PooledTransport, Long> idleEntry : this.idle.entrySet()) {
            long lastUsed = idleEntry.getValue();
            if (lastUsed >= expirationTime) continue;
            PooledTransport removed = idleEntry.getKey();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Expiring idle transport for job [" + this.jobPoolingKey + "], transport: [" + removed.toString() + "]. Last used [" + new TimeValue(now - lastUsed) + "] ago. Expired [" + this.idleTransportTimeout + "] ago."));
            }
            this.release(removed);
            removeFromIdle.add(removed);
        }
        for (PooledTransport toRemove : removeFromIdle) {
            this.idle.remove(toRemove);
        }
        return this.idle.size() + this.leased.size();
    }

    private final class PooledCommonsHttpTransport
    extends CommonsHttpTransport
    implements PooledTransport {
        private final String loggingHostInformation;

        PooledCommonsHttpTransport(Settings settings, SecureSettings secureSettings, String host) {
            super(settings, secureSettings, host);
            this.loggingHostInformation = host;
        }

        @Override
        public void clean() {
            this.stats = new Stats();
        }

        public String toString() {
            return "PooledCommonsHttpTransport{'" + this.loggingHostInformation + "'}";
        }
    }

    private static interface PooledTransport
    extends Transport {
        public void clean();
    }

    private final class LeasedTransport
    implements Transport {
        private final PooledTransport delegate;
        private final TransportPool lender;
        private boolean open = true;
        private Stats finalResults;

        LeasedTransport(PooledTransport delegate, TransportPool lender) {
            this.delegate = delegate;
            this.lender = lender;
        }

        @Override
        public Response execute(Request request) throws IOException {
            if (!this.open) {
                throw new OpenSearchHadoopIllegalStateException("Calling execute on a closed Transport object");
            }
            return this.delegate.execute(request);
        }

        @Override
        public void close() {
            if (this.open) {
                this.open = false;
                this.finalResults = this.delegate.stats();
                this.delegate.clean();
                this.lender.returnTransport(this.delegate);
            }
        }

        @Override
        public Stats stats() {
            if (!this.open) {
                return this.finalResults;
            }
            return this.delegate.stats();
        }
    }
}

