/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest.commonshttp.auth.aws;

import com.amazonaws.DefaultRequest;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.SdkHttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.Request;
import org.opensearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.opensearch.hadoop.thirdparty.google.common.base.Joiner;
import org.opensearch.hadoop.thirdparty.google.common.base.Splitter;
import org.opensearch.hadoop.thirdparty.google.common.base.Strings;
import org.opensearch.hadoop.thirdparty.google.common.collect.ImmutableList;
import org.opensearch.hadoop.thirdparty.google.common.collect.Multimap;

public class AwsV4SignerSupport {
    private static Log log = LogFactory.getLog(AwsV4SignerSupport.class);
    private final Settings settings;
    private final String httpInfo;
    private final AWSCredentials credentials;
    private static final Joiner AMPERSAND_JOINER = Joiner.on('&');

    public AwsV4SignerSupport(Settings settings, String httpInfo) {
        this(settings, httpInfo, null);
    }

    public AwsV4SignerSupport(Settings settings, String httpInfo, AWSCredentials credentials) {
        this.settings = settings;
        this.httpInfo = httpInfo;
        this.credentials = credentials;
    }

    private String queryParamsString(Multimap<String, String> queryParams) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, Collection<String>> param : new TreeMap<String, Collection<String>>(queryParams.asMap()).entrySet()) {
            for (String value : param.getValue()) {
                result.add(SdkHttpUtils.urlEncode((String)param.getKey(), (boolean)false) + '=' + SdkHttpUtils.urlEncode((String)value, (boolean)false));
            }
        }
        return AMPERSAND_JOINER.join(result.build());
    }

    public void sign(Request request, HttpMethod http) throws UnsupportedEncodingException {
        String awsRegion = this.settings.getAwsSigV4Region();
        String awsServiceName = this.settings.getAwsSigV4ServiceName();
        AWS4Signer aws4Signer = new AWS4Signer();
        aws4Signer.setRegionName(awsRegion);
        aws4Signer.setServiceName(awsServiceName);
        DefaultRequest req = new DefaultRequest(awsServiceName);
        req.setHttpMethod(HttpMethodName.valueOf((String)request.method().name()));
        StringBuilder url = new StringBuilder();
        url.append(this.httpInfo);
        String path = request.path().toString();
        req.setResourcePath(path);
        Splitter queryStringSplitter = Splitter.on('&').trimResults().omitEmptyStrings();
        List<String> rawParams = request.params() != null ? queryStringSplitter.split(request.params()) : Collections.emptyList();
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        for (String string : rawParams) {
            if (Strings.isNullOrEmpty(string)) continue;
            String pair = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
            int index = pair.indexOf(61);
            if (index > 0) {
                String key = pair.substring(0, index);
                String value = pair.substring(index + 1);
                queryParams.put(key, Arrays.asList(value));
                continue;
            }
            queryParams.put(pair, Arrays.asList(""));
        }
        req.setParameters(queryParams);
        try {
            req.setEndpoint(new URI(url.toString()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid request URI: " + request.uri().toString());
        }
        if (request.body() != null) {
            req.setContent(request.body().toInputStream());
        }
        req.addHeader("x-amz-content-sha256", "required");
        aws4Signer.sign((SignableRequest)req, this.credentials);
        for (Map.Entry entry : req.getHeaders().entrySet()) {
            http.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

