/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.rest;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.hadoop.rest.HttpStatus;
import org.opensearch.hadoop.rest.Response;
import org.opensearch.hadoop.rest.ReusableInputStream;

public class SimpleResponse
implements Response {
    private final int status;
    private final InputStream body;
    private final CharSequence uri;
    private final Map<String, List<String>> headers;

    public SimpleResponse(int status, InputStream body, CharSequence uri) {
        this(status, body, uri, Collections.emptyMap());
    }

    public SimpleResponse(int status, InputStream body, CharSequence uri, Map<String, List<String>> headers) {
        this.status = status;
        this.body = body;
        this.uri = uri;
        this.headers = headers;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public String statusDescription() {
        return HttpStatus.getText(this.status);
    }

    @Override
    public InputStream body() {
        InputStream copy;
        if (this.body instanceof ReusableInputStream && (copy = ((ReusableInputStream)((Object)this.body)).copy()) != null) {
            return copy;
        }
        return this.body;
    }

    @Override
    public CharSequence uri() {
        return this.uri;
    }

    @Override
    public boolean isInformal() {
        return HttpStatus.isInformal(this.status);
    }

    @Override
    public boolean isSuccess() {
        return HttpStatus.isSuccess(this.status);
    }

    @Override
    public boolean isRedirection() {
        return HttpStatus.isRedirection(this.status);
    }

    @Override
    public boolean isClientError() {
        return HttpStatus.isClientError(this.status);
    }

    @Override
    public boolean isServerError() {
        return HttpStatus.isServerError(this.status);
    }

    @Override
    public boolean hasSucceeded() {
        return this.isSuccess();
    }

    @Override
    public boolean hasFailed() {
        return !this.hasSucceeded();
    }

    @Override
    public List<String> getHeaders(String headerName) {
        return this.headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerName)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

