/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Collections;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.cfg.CompositeSettings;
import org.opensearch.hadoop.cfg.HadoopSettingsManager;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.RestClient;
import org.opensearch.hadoop.security.JdkUser;
import org.opensearch.hadoop.security.JdkUserProvider;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.util.ClusterInfo;
import org.opensearch.hadoop.util.ClusterName;

public class OpenSearchTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text KIND_NAME = new Text("OPENSEARCH_AUTH_TOKEN");

    public static Token<OpenSearchTokenIdentifier> createTokenFrom(OpenSearchToken opensearchToken) {
        OpenSearchTokenIdentifier identifier = new OpenSearchTokenIdentifier();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            opensearchToken.writeOut(new DataOutputStream(buffer));
        }
        catch (IOException e) {
            throw new OpenSearchHadoopException("Could not serialize token information", e);
        }
        byte[] id = identifier.getBytes();
        byte[] pw = buffer.toByteArray();
        Text kind = identifier.getKind();
        Text service = new Text(opensearchToken.getClusterName());
        return new Token(id, pw, kind, service);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public static class Renewer
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return KIND_NAME.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            if (!KIND_NAME.equals((Object)token.getKind())) {
                throw new IOException("Could not renew token of invalid type [" + token.getKind().toString() + "]");
            }
            OpenSearchToken opensearchToken = new OpenSearchToken(new DataInputStream(new ByteArrayInputStream(token.getPassword())));
            return opensearchToken.getExpirationTime();
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            if (!KIND_NAME.equals((Object)token.getKind())) {
                throw new IOException("Could not renew token of invalid type [" + token.getKind().toString() + "]");
            }
            final OpenSearchToken opensearchToken = new OpenSearchToken(new DataInputStream(new ByteArrayInputStream(token.getPassword())));
            Settings settings = HadoopSettingsManager.loadFrom(conf);
            final CompositeSettings compositeSettings = new CompositeSettings(Collections.singletonList(settings));
            ClusterInfo info = new ClusterInfo(new ClusterName(opensearchToken.getClusterName(), null), opensearchToken.getMajorVersion());
            compositeSettings.setInternalClusterInfo(info);
            InitializationUtils.setUserProviderIfNotSet(compositeSettings, JdkUserProvider.class, (Log)new NoOpLog());
            Subject subject = new Subject();
            JdkUser user = new JdkUser(subject, settings);
            user.addOpenSearchToken(opensearchToken);
            user.doAs(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try (RestClient client = null;){
                        client = this.createClient(compositeSettings);
                        client.cancelToken(opensearchToken);
                    }
                    return null;
                }
            });
        }

        protected RestClient createClient(Settings settings) {
            return new RestClient(settings);
        }
    }
}

