/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.security.HadoopRealUserProvider;
import org.opensearch.hadoop.mr.security.OpenSearchTokenIdentifier;
import org.opensearch.hadoop.security.OpenSearchToken;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;
import org.opensearch.hadoop.serialization.OpenSearchHadoopSerializationException;

public class HadoopUser
implements User {
    private final Settings providerSettings;
    private final UserGroupInformation ugi;

    public HadoopUser(UserGroupInformation ugi, Settings providerSettings) {
        this.ugi = ugi;
        this.providerSettings = providerSettings;
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) {
        return (T)this.ugi.doAs(action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws OpenSearchHadoopException {
        try {
            return (T)this.ugi.doAs(action);
        }
        catch (IOException e) {
            throw new OpenSearchHadoopException(e);
        }
        catch (InterruptedException e) {
            throw new OpenSearchHadoopException(e);
        }
        catch (UndeclaredThrowableException e) {
            throw new OpenSearchHadoopException(e);
        }
    }

    @Override
    public OpenSearchToken getOpenSearchToken(String clusterName) {
        if (clusterName == null || clusterName.equals("") || clusterName.equals("!UNNAMED!")) {
            return null;
        }
        for (Token token : this.ugi.getTokens()) {
            if (!OpenSearchTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !clusterName.equals(token.getService().toString())) continue;
            try {
                return new OpenSearchToken(new DataInputStream(new ByteArrayInputStream(token.getPassword())));
            }
            catch (IOException e) {
                throw new OpenSearchHadoopSerializationException("Could not read token information from UGI", e);
            }
        }
        return null;
    }

    @Override
    public Iterable<OpenSearchToken> getAllOpenSearchTokens() {
        ArrayList<OpenSearchToken> tokens = new ArrayList<OpenSearchToken>();
        for (Token token : this.ugi.getTokens()) {
            if (!OpenSearchTokenIdentifier.KIND_NAME.equals((Object)token.getKind())) continue;
            try {
                tokens.add(new OpenSearchToken(new DataInputStream(new ByteArrayInputStream(token.getPassword()))));
            }
            catch (IOException e) {
                throw new OpenSearchHadoopSerializationException("Could not read token information from UGI", e);
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    @Override
    public void addOpenSearchToken(OpenSearchToken opensearchToken) {
        Token<OpenSearchTokenIdentifier> token = OpenSearchTokenIdentifier.createTokenFrom(opensearchToken);
        this.ugi.addToken(token);
    }

    @Override
    public String getUserName() {
        return this.ugi.getUserName();
    }

    @Override
    public KerberosPrincipal getKerberosPrincipal() {
        if (this.ugi.hasKerberosCredentials()) {
            return new KerberosPrincipal(this.ugi.getUserName());
        }
        return null;
    }

    @Override
    public boolean isProxyUser() {
        return UserGroupInformation.AuthenticationMethod.PROXY.equals((Object)this.ugi.getAuthenticationMethod());
    }

    @Override
    public UserProvider getRealUserProvider() {
        HadoopRealUserProvider realProvider = new HadoopRealUserProvider();
        realProvider.setSettings(this.providerSettings);
        return realProvider;
    }

    public String toString() {
        return "HadoopUser{ugi=" + this.ugi + '}';
    }
}

