/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr.security;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.opensearch.hadoop.OpenSearchHadoopException;
import org.opensearch.hadoop.mr.security.HadoopUser;
import org.opensearch.hadoop.security.User;
import org.opensearch.hadoop.security.UserProvider;

public class HadoopRealUserProvider
extends UserProvider {
    private static Log LOG = LogFactory.getLog(HadoopRealUserProvider.class);

    @Override
    public User getUser() {
        try {
            UserGroupInformation realUser;
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            if (!UserGroupInformation.AuthenticationMethod.PROXY.equals((Object)currentUser.getAuthenticationMethod())) {
                return new HadoopUser(currentUser, this.getSettings());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Current user [" + currentUser.getUserName() + "] is proxy user. Retrieving real user."));
            }
            for (realUser = currentUser.getRealUser(); realUser != null && UserGroupInformation.AuthenticationMethod.PROXY.equals((Object)realUser.getAuthenticationMethod()); realUser = realUser.getRealUser()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Found nested proxy user [" + realUser.getUserName() + "]. Checking next real user."));
            }
            if (realUser == null) {
                throw new OpenSearchHadoopException("Could not locate a real user under the current user [" + currentUser + "].");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found real user [" + realUser.getUserName() + "] with auth method of [" + realUser.getAuthenticationMethod() + "]"));
            }
            return new HadoopUser(realUser, this.getSettings());
        }
        catch (IOException e) {
            throw new OpenSearchHadoopException("Could not retrieve the current user", e);
        }
    }
}

