/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.mr;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.opensearch.hadoop.cfg.HadoopSettingsManager;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.mr.HadoopCfgUtils;
import org.opensearch.hadoop.mr.HeartBeat;
import org.opensearch.hadoop.mr.ReportingUtils;
import org.opensearch.hadoop.mr.WritableBytesConverter;
import org.opensearch.hadoop.mr.WritableValueWriter;
import org.opensearch.hadoop.mr.compat.CompatHandler;
import org.opensearch.hadoop.mr.security.HadoopUserProvider;
import org.opensearch.hadoop.rest.InitializationUtils;
import org.opensearch.hadoop.rest.Resource;
import org.opensearch.hadoop.rest.RestRepository;
import org.opensearch.hadoop.rest.RestService;
import org.opensearch.hadoop.serialization.field.MapWritableFieldExtractor;
import org.opensearch.hadoop.util.Assert;

public class OpenSearchOutputFormat
extends OutputFormat
implements org.apache.hadoop.mapred.OutputFormat {
    private static Log log = LogFactory.getLog(OpenSearchOutputFormat.class);
    private static final int NO_TASK_ID = -1;

    public org.apache.hadoop.mapreduce.RecordWriter getRecordWriter(TaskAttemptContext context) {
        return (org.apache.hadoop.mapreduce.RecordWriter)this.getRecordWriter(null, HadoopCfgUtils.asJobConf(CompatHandler.taskAttemptContext(context).getConfiguration()), null, (Progressable)context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException {
        this.init(CompatHandler.jobContext(context).getConfiguration());
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new OpenSearchOutputCommitter();
    }

    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return new OpenSearchRecordWriter((Configuration)job, progress);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf cfg) throws IOException {
        this.init((Configuration)cfg);
    }

    private void init(Configuration cfg) throws IOException {
        Settings settings = HadoopSettingsManager.loadFrom(cfg);
        Assert.hasText(settings.getResourceWrite(), String.format("No resource ['%s'] (index/query/location) specified", "opensearch.resource"));
        InitializationUtils.discoverClusterInfo(settings, log);
        InitializationUtils.checkIdForOperation(settings);
        InitializationUtils.checkIndexExistence(settings);
        if (HadoopCfgUtils.getReduceTasks(cfg) != null) {
            if (HadoopCfgUtils.getSpeculativeReduce(cfg)) {
                log.warn((Object)"Speculative execution enabled for reducer - consider disabling it to prevent data corruption");
            }
        } else if (HadoopCfgUtils.getSpeculativeMap(cfg)) {
            log.warn((Object)"Speculative execution enabled for mapper - consider disabling it to prevent data corruption");
        }
    }

    public static class OpenSearchOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) throws IOException {
        }

        @Deprecated
        public void cleanupJob(JobContext jobContext) throws IOException {
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
        }
    }

    protected static class OpenSearchRecordWriter
    extends org.apache.hadoop.mapreduce.RecordWriter
    implements RecordWriter {
        protected final Configuration cfg;
        protected boolean initialized = false;
        protected RestRepository repository;
        private String uri;
        private Resource resource;
        private HeartBeat beat;
        private final Progressable progressable;

        public OpenSearchRecordWriter(Configuration cfg, Progressable progressable) {
            this.cfg = cfg;
            this.progressable = progressable;
        }

        public void write(Object key, Object value) throws IOException {
            if (!this.initialized) {
                this.initialized = true;
                this.init();
            }
            this.repository.writeToIndex(value);
        }

        protected void init() throws IOException {
            int currentInstance = this.detectCurrentInstance(this.cfg);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("OpenSearchRecordWriter instance [%s] initiating discovery of target shard...", currentInstance));
            }
            Settings settings = HadoopSettingsManager.loadFrom(this.cfg).copy();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Init shard writer from cfg %s", HadoopCfgUtils.asProperties(this.cfg)));
            }
            InitializationUtils.setValueWriterIfNotSet(settings, WritableValueWriter.class, log);
            InitializationUtils.setBytesConverterIfNeeded(settings, WritableBytesConverter.class, log);
            InitializationUtils.setFieldExtractorIfNotSet(settings, MapWritableFieldExtractor.class, log);
            InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, log);
            RestService.PartitionWriter pw = RestService.createWriter(settings, currentInstance, -1, log);
            this.repository = pw.repository;
            if (this.progressable != null) {
                this.beat = new HeartBeat(this.progressable, this.cfg, settings.getHeartBeatLead(), log);
                this.beat.start();
            }
        }

        private int detectCurrentInstance(Configuration conf) {
            TaskID taskID = HadoopCfgUtils.getTaskID(conf);
            if (taskID == null) {
                log.warn((Object)String.format("Cannot determine task id - redirecting writes in a random fashion", new Object[0]));
                return -1;
            }
            return taskID.getId();
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.doClose((Progressable)context);
        }

        public void close(Reporter reporter) throws IOException {
            this.doClose((Progressable)reporter);
        }

        protected void doClose(Progressable progressable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Closing RecordWriter [%s][%s]", this.uri, this.resource));
            }
            if (this.beat != null) {
                this.beat.stop();
            }
            if (this.repository != null) {
                this.repository.close();
                ReportingUtils.report(progressable, this.repository.stats());
            }
            this.initialized = false;
        }
    }

    public static class OpenSearchOldAPIOutputCommitter
    extends org.apache.hadoop.mapred.OutputCommitter {
        public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
        }

        public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            return false;
        }

        public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
        }

        @Deprecated
        public void cleanupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        }
    }
}

