/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.handler.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.hadoop.OpenSearchHadoopIllegalArgumentException;
import org.opensearch.hadoop.cfg.Settings;
import org.opensearch.hadoop.handler.ErrorHandler;
import org.opensearch.hadoop.handler.HandlerLoader;
import org.opensearch.hadoop.serialization.SettingsAware;
import org.opensearch.hadoop.util.Assert;
import org.opensearch.hadoop.util.ObjectUtils;
import org.opensearch.hadoop.util.StringUtils;

public abstract class AbstractHandlerLoader<E extends ErrorHandler>
implements SettingsAware,
HandlerLoader<E> {
    private static final Log LOG = LogFactory.getLog(AbstractHandlerLoader.class);
    private final Class<E> expected;
    private Settings settings;

    public AbstractHandlerLoader(Class<E> expected) {
        this.expected = expected;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    @Override
    public List<E> loadHandlers() {
        Assert.notNull(this.settings, "No settings are present in the handler loader!");
        String handlerListPropertyName = this.getHandlersPropertyName();
        String handlerPropertyPrefix = this.getHandlerPropertyName();
        ArrayList<E> handlers = new ArrayList<E>();
        List<String> handlerNames = StringUtils.tokenize(this.settings.getProperty(handlerListPropertyName));
        boolean failureHandlerAdded = false;
        for (String handlerName : handlerNames) {
            Object handler;
            Settings handlerSettings = this.settings.getSettingsView(handlerPropertyPrefix + "." + handlerName);
            if (handlerName.equals(NamedHandlers.FAIL.name)) {
                handler = this.loadBuiltInHandler(NamedHandlers.FAIL);
                failureHandlerAdded = true;
            } else if (handlerName.equals(NamedHandlers.LOG.name)) {
                handler = this.loadBuiltInHandler(NamedHandlers.LOG);
            } else if (handlerName.equals(NamedHandlers.OPENSEARCH.name)) {
                handler = this.loadBuiltInHandler(NamedHandlers.OPENSEARCH);
            } else {
                String handlerClassName = this.settings.getProperty(handlerPropertyPrefix + "." + handlerName);
                handler = (ErrorHandler)ObjectUtils.instantiate(handlerClassName, AbstractHandlerLoader.class.getClassLoader());
            }
            if (handler == null) continue;
            if (!this.expected.isAssignableFrom(handler.getClass())) {
                throw new OpenSearchHadoopIllegalArgumentException("Invalid handler configuration. Expected a handler that extends or is of type [" + this.expected + "] but was given a handler named [" + handlerName + "] that is an instance of type [" + handler.getClass() + "] which is not compatible.");
            }
            if (failureHandlerAdded && !handlerName.equals(NamedHandlers.FAIL.name)) {
                LOG.warn((Object)String.format("Found error handler named [%s] ordered after the built in failure handler. This handler will never be called as the failure handler preceding it will consume any and all errors. Consider reordering your handlers in the [%s] property.", handlerName, handlerListPropertyName));
            }
            handler.init(handlerSettings.asProperties());
            handlers.add(handler);
        }
        if (!failureHandlerAdded) {
            E handler = this.loadBuiltInHandler(NamedHandlers.FAIL);
            Settings handlerSettings = this.settings.getSettingsView(handlerPropertyPrefix + "." + NamedHandlers.FAIL.name);
            handler.init(handlerSettings.asProperties());
            handlers.add(handler);
        }
        return handlers;
    }

    protected abstract String getHandlersPropertyName();

    protected abstract String getHandlerPropertyName();

    protected abstract E loadBuiltInHandler(NamedHandlers var1);

    public static enum NamedHandlers {
        FAIL("fail"),
        LOG("log"),
        OPENSEARCH("opensearch");

        private final String name;

        private NamedHandlers(String name) {
            this.name = name;
        }
    }
}

