/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import org.opensearch.hadoop.cli.Prompt;

public class ConsolePrompt
implements Prompt {
    private final Console console = System.console();

    @Override
    public void println() {
        System.out.println();
    }

    @Override
    public void println(String s) {
        System.out.println(s);
    }

    @Override
    public void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    @Override
    public String readLine() {
        if (this.console == null) {
            try {
                return new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        return this.console.readLine();
    }

    @Override
    public String readLine(String format, Object ... args) {
        this.printf(format, args);
        return this.readLine();
    }

    @Override
    public char[] readPassword(String prompt, Object ... args) {
        if (this.console == null) {
            throw new IllegalStateException("Cannot disable console echo to read password");
        }
        return this.console.readPassword(prompt, args);
    }
}

