/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Properties;
import org.opensearch.hadoop.cfg.Settings;

class SettingsView
extends Settings {
    private final Settings parent;
    private final String namespace;

    SettingsView(Settings parent, String namespace) {
        this.parent = parent;
        this.namespace = namespace;
    }

    private String makeKey(String name) {
        return this.namespace + "." + name;
    }

    @Override
    public InputStream loadResource(String location) {
        throw new UnsupportedOperationException("Settings views do not support loading resources.");
    }

    @Override
    public Settings copy() {
        return new SettingsView(this.parent.copy(), this.namespace);
    }

    @Override
    public String getProperty(String name) {
        return this.parent.getProperty(this.makeKey(name));
    }

    @Override
    public void setProperty(String name, String value) {
        this.parent.setProperty(this.makeKey(name), value);
    }

    @Override
    public Properties asProperties() {
        Properties parentSettings = this.parent.asProperties();
        Properties viewProperties = new Properties();
        String prefix = this.namespace + ".";
        for (Object keyObject : parentSettings.keySet()) {
            String key = keyObject.toString();
            if (!key.startsWith(prefix) || key.equals(prefix)) continue;
            String newKey = key.substring(prefix.length());
            viewProperties.put(newKey, parentSettings.getProperty(key));
        }
        return viewProperties;
    }
}

