/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

// typedef: _types.query_dsl.TermsQuery

@JsonpDeserializable
public class TermsQuery extends QueryBase implements QueryVariant {
    private final String field;

    private final TermsQueryField terms;

    // ---------------------------------------------------------------------------------------------

    private TermsQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.terms = ApiTypeHelper.requireNonNull(builder.terms, this, "terms");

    }

    public static TermsQuery of(Function<Builder, ObjectBuilder<TermsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Query variant kind.
     */
    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Terms;
    }

    /**
     * Required -
     */
    public final String field() {
        return this.field;
    }

    /**
     * Required -
     */
    public final TermsQueryField terms() {
        return this.terms;
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.terms.serialize(generator, mapper);

        super.serializeInternal(generator, mapper);

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link TermsQuery}.
     */

    public static class Builder extends QueryBase.AbstractBuilder<Builder> implements ObjectBuilder<TermsQuery> {
        private String field;

        private TermsQueryField terms;

        /**
         * Required -
         */
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        /**
         * Required -
         */
        public final Builder terms(TermsQueryField value) {
            this.terms = value;
            return this;
        }

        /**
         * Required -
         */
        public final Builder terms(Function<TermsQueryField.Builder, ObjectBuilder<TermsQueryField>> fn) {
            return this.terms(fn.apply(new TermsQueryField.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        /**
         * Builds a {@link TermsQuery}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public TermsQuery build() {
            _checkSingleUse();

            return new TermsQuery(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link TermsQuery}
     */
    public static final JsonpDeserializer<TermsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        TermsQuery::setupTermsQueryDeserializer
    );

    protected static void setupTermsQueryDeserializer(ObjectDeserializer<TermsQuery.Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);

        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field(name);
            builder.terms(TermsQueryField._DESERIALIZER.deserialize(parser, mapper));
        });

    }

}
