/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Level;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.NodesStatsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class NodesStatsRequest
extends RequestBase {
    private final List<String> completionFields;
    private final List<String> fielddataFields;
    private final List<String> fields;
    @Nullable
    private final Boolean groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nullable
    private final Boolean includeUnloadedSegments;
    private final List<String> indexMetric;
    @Nullable
    private final Level level;
    @Nullable
    private final Time masterTimeout;
    private final List<String> metric;
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    private final List<String> types;
    public static final Endpoint<NodesStatsRequest, NodesStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesStatsRequest, NodesStatsResponse>(request -> "GET", request -> {
        boolean _metric = true;
        int _indexMetric = 2;
        int _nodeId = 4;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.indexMetric())) {
            propsSet |= 2;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 4) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 5) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.types)) {
            params.put("types", request.types.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.level != null) {
            params.put("level", request.level.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.completionFields)) {
            params.put("completion_fields", request.completionFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.fielddataFields)) {
            params.put("fielddata_fields", request.fielddataFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.groups != null) {
            params.put("groups", String.valueOf(request.groups));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (ApiTypeHelper.isDefined(request.fields)) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(request.includeSegmentFileSizes));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesStatsResponse._DESERIALIZER);

    private NodesStatsRequest(Builder builder) {
        this.completionFields = ApiTypeHelper.unmodifiable(builder.completionFields);
        this.fielddataFields = ApiTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.groups = builder.groups;
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.indexMetric = ApiTypeHelper.unmodifiable(builder.indexMetric);
        this.level = builder.level;
        this.masterTimeout = builder.masterTimeout;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static NodesStatsRequest of(Function<Builder, ObjectBuilder<NodesStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> completionFields() {
        return this.completionFields;
    }

    public final List<String> fielddataFields() {
        return this.fielddataFields;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean groups() {
        return this.groups;
    }

    @Nullable
    public final Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nullable
    public final Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public final List<String> indexMetric() {
        return this.indexMetric;
    }

    @Nullable
    public final Level level() {
        return this.level;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> metric() {
        return this.metric;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final List<String> types() {
        return this.types;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodesStatsRequest> {
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private List<String> indexMetric;
        @Nullable
        private Level level;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;
        @Nullable
        private List<String> types;

        public final Builder completionFields(List<String> list) {
            this.completionFields = Builder._listAddAll(this.completionFields, list);
            return this;
        }

        public final Builder completionFields(String value, String ... values) {
            this.completionFields = Builder._listAdd(this.completionFields, value, values);
            return this;
        }

        public final Builder fielddataFields(List<String> list) {
            this.fielddataFields = Builder._listAddAll(this.fielddataFields, list);
            return this;
        }

        public final Builder fielddataFields(String value, String ... values) {
            this.fielddataFields = Builder._listAdd(this.fielddataFields, value, values);
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder groups(@Nullable Boolean value) {
            this.groups = value;
            return this;
        }

        public final Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        public final Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public final Builder indexMetric(List<String> list) {
            this.indexMetric = Builder._listAddAll(this.indexMetric, list);
            return this;
        }

        public final Builder indexMetric(String value, String ... values) {
            this.indexMetric = Builder._listAdd(this.indexMetric, value, values);
            return this;
        }

        public final Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder metric(List<String> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(String value, String ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        public NodesStatsRequest build() {
            this._checkSingleUse();
            return new NodesStatsRequest(this);
        }
    }
}

