/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.ingest.GetPipelineResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class GetPipelineRequest
extends RequestBase {
    @Nullable
    private final String id;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean summary;
    public static final Endpoint<GetPipelineRequest, GetPipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetPipelineRequest, GetPipelineResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.summary != null) {
            params.put("summary", String.valueOf(request.summary));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetPipelineResponse._DESERIALIZER);

    private GetPipelineRequest(Builder builder) {
        this.id = builder.id;
        this.masterTimeout = builder.masterTimeout;
        this.summary = builder.summary;
    }

    public static GetPipelineRequest of(Function<Builder, ObjectBuilder<GetPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean summary() {
        return this.summary;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetPipelineRequest> {
        @Nullable
        private String id;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean summary;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder summary(@Nullable Boolean value) {
            this.summary = value;
            return this;
        }

        @Override
        public GetPipelineRequest build() {
            this._checkSingleUse();
            return new GetPipelineRequest(this);
        }
    }
}

