/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.RolloverResponse;
import org.opensearch.client.opensearch.indices.rollover.IndexRolloverMapping;
import org.opensearch.client.opensearch.indices.rollover.RolloverConditions;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RolloverRequest
extends RequestBase
implements JsonpSerializable {
    private final String alias;
    private final Map<String, Alias> aliases;
    @Nullable
    private final RolloverConditions conditions;
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final IndexRolloverMapping mappings;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String newIndex;
    private final Map<String, JsonData> settings;
    @Nullable
    private final Time timeout;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    public static final JsonpDeserializer<RolloverRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverRequest::setupRolloverRequestDeserializer);
    public static final Endpoint<RolloverRequest, RolloverResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RolloverRequest, RolloverResponse>(request -> "POST", request -> {
        boolean _newIndex = true;
        int _alias = 2;
        int propsSet = 0;
        if (request.newIndex() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.alias, buf);
            buf.append("/_rollover");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.alias, buf);
            buf.append("/_rollover");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.newIndex, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RolloverResponse._DESERIALIZER);

    private RolloverRequest(Builder builder) {
        this.alias = ApiTypeHelper.requireNonNull(builder.alias, this, "alias");
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.conditions = builder.conditions;
        this.dryRun = builder.dryRun;
        this.includeTypeName = builder.includeTypeName;
        this.mappings = builder.mappings;
        this.masterTimeout = builder.masterTimeout;
        this.newIndex = builder.newIndex;
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    public static RolloverRequest of(Function<Builder, ObjectBuilder<RolloverRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String alias() {
        return this.alias;
    }

    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public final RolloverConditions conditions() {
        return this.conditions;
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public final IndexRolloverMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String newIndex() {
        return this.newIndex;
    }

    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.conditions != null) {
            generator.writeKey("conditions");
            this.conditions.serialize(generator, mapper);
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRolloverRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::conditions, RolloverConditions._DESERIALIZER, "conditions");
        op.add(Builder::mappings, IndexRolloverMapping._DESERIALIZER, "mappings");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RolloverRequest> {
        private String alias;
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private RolloverConditions conditions;
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private IndexRolloverMapping mappings;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String newIndex;
        @Nullable
        private Map<String, JsonData> settings;
        @Nullable
        private Time timeout;
        @Nullable
        private WaitForActiveShards waitForActiveShards;

        public final Builder alias(String value) {
            this.alias = value;
            return this;
        }

        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        public final Builder conditions(@Nullable RolloverConditions value) {
            this.conditions = value;
            return this;
        }

        public final Builder conditions(Function<RolloverConditions.Builder, ObjectBuilder<RolloverConditions>> fn) {
            return this.conditions(fn.apply(new RolloverConditions.Builder()).build());
        }

        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public final Builder mappings(@Nullable IndexRolloverMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<IndexRolloverMapping.Builder, ObjectBuilder<IndexRolloverMapping>> fn) {
            return this.mappings(fn.apply(new IndexRolloverMapping.Builder()).build());
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder newIndex(@Nullable String value) {
            this.newIndex = value;
            return this;
        }

        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        @Override
        public RolloverRequest build() {
            this._checkSingleUse();
            return new RolloverRequest(this);
        }
    }
}

