/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.dangling_indices;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.dangling_indices.DeleteDanglingIndexResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class DeleteDanglingIndexRequest
extends RequestBase {
    private final boolean acceptDataLoss;
    private final String indexUuid;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse>(request -> "DELETE", request -> {
        boolean _indexUuid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_dangling");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexUuid, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        params.put("accept_data_loss", String.valueOf(request.acceptDataLoss));
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteDanglingIndexResponse._DESERIALIZER);

    private DeleteDanglingIndexRequest(Builder builder) {
        this.acceptDataLoss = ApiTypeHelper.requireNonNull(builder.acceptDataLoss, this, "acceptDataLoss");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public static DeleteDanglingIndexRequest of(Function<Builder, ObjectBuilder<DeleteDanglingIndexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean acceptDataLoss() {
        return this.acceptDataLoss;
    }

    public final String indexUuid() {
        return this.indexUuid;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeleteDanglingIndexRequest> {
        private Boolean acceptDataLoss;
        private String indexUuid;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;

        public final Builder acceptDataLoss(boolean value) {
            this.acceptDataLoss = value;
            return this;
        }

        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public DeleteDanglingIndexRequest build() {
            this._checkSingleUse();
            return new DeleteDanglingIndexRequest(this);
        }
    }
}

