/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.TotalHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class HitsMetadata<T>
implements JsonpSerializable {
    private final TotalHits total;
    private final List<Hit<T>> hits;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    private HitsMetadata(Builder<T> builder) {
        this.total = ApiTypeHelper.requireNonNull(((Builder)builder).total, this, "total");
        this.hits = ApiTypeHelper.unmodifiableRequired(((Builder)builder).hits, (Object)this, "hits");
        this.maxScore = ((Builder)builder).maxScore;
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public static <T> HitsMetadata<T> of(Function<Builder<T>, ObjectBuilder<HitsMetadata<T>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final TotalHits total() {
        return this.total;
    }

    public final List<Hit<T>> hits() {
        return this.hits;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.hits)) {
            generator.writeKey("hits");
            generator.writeStartArray();
            for (Hit<T> item0 : this.hits) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
    }

    public static <T> JsonpDeserializer<HitsMetadata<T>> createHitsMetadataDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsMetadata.setupHitsMetadataDeserializer(op, tDeserializer));
    }

    protected static <T> void setupHitsMetadataDeserializer(ObjectDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::total, TotalHits._DESERIALIZER, "total");
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(tDeserializer)), "hits");
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
    }

    public static class Builder<T>
    extends ObjectBuilderBase
    implements ObjectBuilder<HitsMetadata<T>> {
        private TotalHits total;
        private List<Hit<T>> hits;
        @Nullable
        private Double maxScore;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public final Builder<T> total(TotalHits value) {
            this.total = value;
            return this;
        }

        public final Builder<T> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        public final Builder<T> hits(List<Hit<T>> list) {
            this.hits = Builder._listAddAll(this.hits, list);
            return this;
        }

        public final Builder<T> hits(Hit<T> value, Hit<T> ... values) {
            this.hits = Builder._listAdd(this.hits, value, values);
            return this;
        }

        public final Builder<T> hits(Function<Hit.Builder<T>, ObjectBuilder<Hit<T>>> fn) {
            return this.hits(fn.apply(new Hit.Builder()).build(), new Hit[0]);
        }

        public final Builder<T> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public final Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        public HitsMetadata<T> build() {
            this._checkSingleUse();
            return new HitsMetadata(this);
        }
    }
}

