/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.NdJsonpSerializable;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.BulkOperationBase;
import org.opensearch.client.opensearch.core.bulk.BulkOperationVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public class UpdateOperation<TDocument>
extends BulkOperationBase
implements NdJsonpSerializable,
BulkOperationVariant {
    private final TDocument document;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Integer retryOnConflict;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    private UpdateOperation(Builder<TDocument> builder) {
        super(builder);
        this.document = ApiTypeHelper.requireNonNull(((Builder)builder).document, this, "document");
        this.requireAlias = ((Builder)builder).requireAlias;
        this.retryOnConflict = ((Builder)builder).retryOnConflict;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> UpdateOperation<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<UpdateOperation<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public BulkOperation.Kind _bulkOperationKind() {
        return BulkOperation.Kind.Update;
    }

    public final TDocument document() {
        return this.document;
    }

    @Override
    public Iterator<?> _serializables() {
        return Arrays.asList(this, this.document).iterator();
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Integer retryOnConflict() {
        return this.retryOnConflict;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.requireAlias != null) {
            generator.writeKey("require_alias");
            generator.write(this.requireAlias.booleanValue());
        }
        if (this.retryOnConflict != null) {
            generator.writeKey("retry_on_conflict");
            generator.write(this.retryOnConflict.intValue());
        }
    }

    public static class Builder<TDocument>
    extends BulkOperationBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<UpdateOperation<TDocument>> {
        private TDocument document;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument> retryOnConflict(@Nullable Integer value) {
            this.retryOnConflict = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public UpdateOperation<TDocument> build() {
            this._checkSingleUse();
            return new UpdateOperation(this);
        }
    }
}

