/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.NamedDeserializer;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SearchTemplateResponse<TDocument>
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final boolean timedOut;
    private final int took;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<SearchTemplateResponse<Object>> _DESERIALIZER = SearchTemplateResponse.createSearchTemplateResponseDeserializer(new NamedDeserializer("org.opensearch.client:Deserializer:_global.search_template.TDocument"));

    private SearchTemplateResponse(Builder<TDocument> builder) {
        this.shards = ApiTypeHelper.requireNonNull(((Builder)builder).shards, this, "shards");
        this.timedOut = ApiTypeHelper.requireNonNull(((Builder)builder).timedOut, this, "timedOut");
        this.took = ApiTypeHelper.requireNonNull(((Builder)builder).took, this, "took");
        this.hits = ApiTypeHelper.requireNonNull(((Builder)builder).hits, this, "hits");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> SearchTemplateResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<SearchTemplateResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final int took() {
        return this.took;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    public static <TDocument> JsonpDeserializer<SearchTemplateResponse<TDocument>> createSearchTemplateResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> SearchTemplateResponse.setupSearchTemplateResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupSearchTemplateResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, JsonpDeserializer.integerDeserializer(), "took");
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchTemplateResponse<TDocument>> {
        private ShardStatistics shards;
        private Boolean timedOut;
        private Integer took;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder<TDocument> took(int value) {
            this.took = value;
            return this;
        }

        public final Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public final Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public SearchTemplateResponse<TDocument> build() {
            this._checkSingleUse();
            return new SearchTemplateResponse(this);
        }
    }
}

