/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class ExistsComponentTemplateRequest
extends RequestBase {
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    public static final Endpoint<ExistsComponentTemplateRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<ExistsComponentTemplateRequest>("opensearch/cluster.exists_component_template", request -> "HEAD", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, null);

    private ExistsComponentTemplateRequest(Builder builder) {
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
    }

    public static ExistsComponentTemplateRequest of(Function<Builder, ObjectBuilder<ExistsComponentTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExistsComponentTemplateRequest> {
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        private List<String> name;

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        @Override
        public ExistsComponentTemplateRequest build() {
            this._checkSingleUse();
            return new ExistsComponentTemplateRequest(this);
        }
    }
}

