/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.util.EnumSet;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpDeserializerBase;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpMapperBase;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.jackson.JacksonJsonProvider;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;
import org.opensearch.client.json.jackson.JacksonJsonpParser;
import org.opensearch.client.json.jackson.JacksonUtils;

public class JacksonJsonpMapper
extends JsonpMapperBase {
    private final JacksonJsonProvider provider = new JacksonJsonProvider();
    private final ObjectMapper objectMapper;

    public JacksonJsonpMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public JacksonJsonpMapper() {
        this(new ObjectMapper());
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @Override
    public JsonProvider jsonProvider() {
        return this.provider;
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> clazz) {
        return new JacksonValueParser<T>(clazz);
    }

    @Override
    public <T> void serialize(T value, JsonGenerator generator) {
        if (!(generator instanceof JacksonJsonpGenerator)) {
            throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
        }
        JsonpSerializer<T> serializer = JacksonJsonpMapper.findSerializer(value);
        if (serializer != null) {
            serializer.serialize(value, generator, this);
            return;
        }
        com.fasterxml.jackson.core.JsonGenerator jkGenerator = ((JacksonJsonpGenerator)generator).jacksonGenerator();
        try {
            this.objectMapper.writeValue(jkGenerator, value);
        }
        catch (IOException ioe) {
            throw JacksonUtils.convertException(ioe);
        }
    }

    private class JacksonValueParser<T>
    extends JsonpDeserializerBase<T> {
        private final Class<T> clazz;

        protected JacksonValueParser(Class<T> clazz) {
            super(EnumSet.allOf(JsonParser.Event.class));
            this.clazz = clazz;
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (!(parser instanceof JacksonJsonpParser)) {
                throw new IllegalArgumentException("Jackson's ObjectMapper can only be used with the JacksonJsonpProvider");
            }
            com.fasterxml.jackson.core.JsonParser jkParser = ((JacksonJsonpParser)parser).jacksonParser();
            try {
                return (T)JacksonJsonpMapper.this.objectMapper.readValue(jkParser, this.clazz);
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }
    }
}

