/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.Iterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;

public abstract class QueryBond
extends QueryChemObject
implements IQueryBond {
    protected IBond.Order order = (IBond.Order)CDKConstants.UNSET;
    protected int atomCount = 0;
    protected IAtom[] atoms = null;
    protected IBond.Stereo stereo;
    protected Integer electronCount;

    public QueryBond(IChemObjectBuilder builder) {
        this(null, null, null, IBond.Stereo.NONE, builder);
        this.atomCount = 0;
    }

    public QueryBond(IAtom atom1, IAtom atom2, IChemObjectBuilder builder) {
        this(atom1, atom2, IBond.Order.SINGLE, IBond.Stereo.NONE, builder);
    }

    public QueryBond(IAtom atom1, IAtom atom2, IBond.Order order, IChemObjectBuilder builder) {
        this(atom1, atom2, order, IBond.Stereo.NONE, builder);
    }

    public QueryBond(IAtom[] atoms, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
    }

    public QueryBond(IAtom[] atoms, IBond.Order order, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
        this.order = order;
    }

    public QueryBond(IAtom atom1, IAtom atom2, IBond.Order order, IBond.Stereo stereo, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[2];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.order = order;
        this.stereo = stereo;
        this.atomCount = 2;
    }

    public Iterable<IAtom> atoms() {
        return new Iterable<IAtom>(){

            @Override
            public Iterator<IAtom> iterator() {
                return new AtomsIterator();
            }
        };
    }

    public int getIndex() {
        return 0;
    }

    public IAtomContainer getContainer() {
        return null;
    }

    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
        this.notifyChanged();
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public IAtom getAtom(int position) {
        if (this.atoms == null) {
            return null;
        }
        return this.atoms[position];
    }

    public IAtom getBegin() {
        return this.atoms[0];
    }

    public IAtom getEnd() {
        return this.atoms[1];
    }

    public IAtom getOther(IAtom atom) {
        if (this.atoms[0].equals(atom)) {
            return this.atoms[1];
        }
        if (this.atoms[1].equals(atom)) {
            return this.atoms[0];
        }
        return null;
    }

    public IAtom getConnectedAtom(IAtom atom) {
        return this.getOther(atom);
    }

    public IAtom[] getConnectedAtoms(IAtom atom) {
        if (this.atomCount < 1) {
            return null;
        }
        IAtom[] connected = new IAtom[this.atomCount - 1];
        int j = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].equals(atom)) continue;
            if (j >= connected.length) {
                return null;
            }
            connected[j++] = this.atoms[i];
        }
        return connected;
    }

    public boolean contains(IAtom atom) {
        if (this.atoms == null) {
            return false;
        }
        for (IAtom localAtom : this.atoms) {
            if (!localAtom.equals(atom)) continue;
            return true;
        }
        return false;
    }

    public void setAtom(IAtom atom, int position) {
        if (this.atoms[position] == null && atom != null) {
            ++this.atomCount;
        }
        if (this.atoms[position] != null && atom == null) {
            --this.atomCount;
        }
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    public IBond.Order getOrder() {
        return this.order;
    }

    public void setOrder(IBond.Order order) {
        this.order = order;
        this.notifyChanged();
    }

    public IBond.Stereo getStereo() {
        return this.stereo;
    }

    public void setStereo(IBond.Stereo stereo) {
        this.stereo = stereo;
        this.notifyChanged();
    }

    public Point2d get2DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint2d().x;
            yOfCenter += atom.getPoint2d().y;
        }
        return new Point2d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount());
    }

    public Point3d get3DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        double zOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint3d().x;
            yOfCenter += atom.getPoint3d().y;
            zOfCenter += atom.getPoint3d().z;
        }
        return new Point3d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount(), zOfCenter / (double)this.getAtomCount());
    }

    public boolean compare(Object object) {
        if (object instanceof IQueryBond) {
            QueryBond queryBond = (QueryBond)object;
            for (IAtom atom : this.atoms) {
                if (queryBond.contains(atom)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isConnectedTo(IBond bond) {
        for (IAtom atom : this.atoms) {
            if (!bond.contains(atom)) continue;
            return true;
        }
        return false;
    }

    public IQueryBond clone() throws CloneNotSupportedException {
        QueryBond clone = (QueryBond)super.clone();
        if (this.atoms != null) {
            clone.atoms = new IAtom[this.atoms.length];
            for (int f = 0; f < this.atoms.length; ++f) {
                if (this.atoms[f] == null) continue;
                clone.atoms[f] = this.atoms[f].clone();
            }
        }
        return clone;
    }

    public String toString() {
        StringBuffer resultString = new StringBuffer(32);
        resultString.append("Bond(").append(this.hashCode());
        if (this.getOrder() != null) {
            resultString.append(", #O:").append(this.getOrder());
        }
        resultString.append(", #S:").append(this.getStereo());
        if (this.getAtomCount() > 0) {
            resultString.append(", #A:").append(this.getAtomCount());
            for (int i = 0; i < this.atomCount; ++i) {
                resultString.append(", ").append(this.atoms[i] == null ? "null" : this.atoms[i].toString());
            }
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }

    public Integer getElectronCount() {
        return this.electronCount;
    }

    public boolean isAromatic() {
        return this.getFlag(32);
    }

    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    public boolean isInRing() {
        return this.getFlag(2);
    }

    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    public void setElectronCount(Integer electronCount) {
        this.electronCount = electronCount;
        this.notifyChanged();
    }

    private class AtomsIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryBond.this.atomCount;
        }

        @Override
        public IAtom next() {
            ++this.pointer;
            return QueryBond.this.atoms[this.pointer - 1];
        }

        @Override
        public void remove() {
        }
    }
}

