/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.OrderQueryBondOrderOnly;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.isomorphism.matchers.SymbolAndChargeQueryAtom;
import org.openscience.cdk.isomorphism.matchers.SymbolChargeIDQueryAtom;
import org.openscience.cdk.isomorphism.matchers.SymbolQueryAtom;

public class QueryAtomContainerCreator {
    public static QueryAtomContainer createBasicQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom((IAtom)new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (bond.getFlag(32)) {
                queryContainer.addBond((IBond)new AromaticQueryBond((IAtom)((IQueryAtom)queryContainer.getAtom(index1)), (IAtom)((IQueryAtom)queryContainer.getAtom(index2)), container.getBuilder()));
                continue;
            }
            queryContainer.addBond((IBond)new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolAndBondOrderQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom((IAtom)new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            queryContainer.addBond((IBond)new OrderQueryBondOrderOnly((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolAndChargeQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom((IAtom)new SymbolAndChargeQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (bond.getFlag(32)) {
                queryContainer.addBond((IBond)new AromaticQueryBond((IAtom)((IQueryAtom)queryContainer.getAtom(index1)), (IAtom)((IQueryAtom)queryContainer.getAtom(index2)), container.getBuilder()));
                continue;
            }
            queryContainer.addBond((IBond)new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createSymbolChargeIDQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom((IAtom)new SymbolChargeIDQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (bond.getFlag(32)) {
                queryContainer.addBond((IBond)new AromaticQueryBond((IAtom)((IQueryAtom)queryContainer.getAtom(index1)), (IAtom)((IQueryAtom)queryContainer.getAtom(index2)), container.getBuilder()));
                continue;
            }
            queryContainer.addBond((IBond)new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomContainer(IAtomContainer container, boolean aromaticity) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (aromaticity && container.getAtom(i).getFlag(32)) {
                queryContainer.addAtom((IAtom)new AromaticAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom((IAtom)new AnyAtom(container.getBuilder()));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (aromaticity && bond.getFlag(32)) {
                queryContainer.addBond((IBond)new AromaticQueryBond((IAtom)((IQueryAtom)queryContainer.getAtom(index1)), (IAtom)((IQueryAtom)queryContainer.getAtom(index2)), container.getBuilder()));
                continue;
            }
            queryContainer.addBond((IBond)new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomAnyBondContainer(IAtomContainer container, boolean aromaticity) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (aromaticity && container.getAtom(i).getFlag(32)) {
                queryContainer.addAtom((IAtom)new AromaticAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom((IAtom)new AnyAtom(container.getBuilder()));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            queryContainer.addBond((IBond)new AnyOrderBond(queryContainer.getAtom(index1), queryContainer.getAtom(index2), container.getBuilder()));
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomForPseudoAtomQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (container.getAtom(i) instanceof IPseudoAtom) {
                queryContainer.addAtom((IAtom)new AnyAtom(container.getBuilder()));
                continue;
            }
            queryContainer.addAtom((IAtom)new SymbolQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (bond.getFlag(32)) {
                queryContainer.addBond((IBond)new AromaticQueryBond((IAtom)((IQueryAtom)queryContainer.getAtom(index1)), (IAtom)((IQueryAtom)queryContainer.getAtom(index2)), container.getBuilder()));
                continue;
            }
            queryContainer.addBond((IBond)new OrderQueryBond((IQueryAtom)queryContainer.getAtom(index1), (IQueryAtom)queryContainer.getAtom(index2), bond.getOrder(), container.getBuilder()));
        }
        return queryContainer;
    }

    private static final class AromaticQueryBond
    extends QueryBond {
        private AromaticQueryBond(IAtom either, IAtom other, IChemObjectBuilder builder) {
            super(either, other, IBond.Order.UNSET, builder);
        }

        public boolean matches(IBond bond) {
            return bond.getFlag(32);
        }
    }

    private static final class AnyOrderBond
    extends QueryBond {
        private AnyOrderBond(IAtom either, IAtom other, IChemObjectBuilder builder) {
            super(either, other, IBond.Order.UNSET, builder);
        }

        public boolean matches(IBond bond) {
            return bond != null && bond.getOrder() != IBond.Order.UNSET;
        }
    }

    private static final class AromaticAtom
    extends QueryAtom {
        private AromaticAtom(IChemObjectBuilder builder) {
            super(builder);
        }

        @Override
        public boolean matches(IAtom atom) {
            return atom.getFlag(32);
        }
    }

    private static final class AnyAtom
    extends QueryAtom {
        private AnyAtom(IChemObjectBuilder builder) {
            super(builder);
        }

        @Override
        public boolean matches(IAtom atom) {
            return true;
        }
    }
}

