/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.DeleteProperty;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CommentOutProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to be commented out.", example="applicability.singleSource")
    private final String propertyKey;
    @Option(displayName="Comment text", description="The comment text to be added before the specified key.", example="The `foo` property is deprecated, please migrate")
    private final String commentText;
    @Option(example="true", displayName="Comment out property", description="If false, property wouldn't be commented out, only comment will be added. By default, set to true", required=false)
    private final @Nullable Boolean commentOutProperty;

    public String getDisplayName() {
        return "Comment out property";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s`", this.propertyKey);
    }

    public String getDescription() {
        return "Comment out a YAML property and add a comment in front.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){
            private boolean nextDocNeedsNewline;
            private String comment = "";
            private String indentation = "";
            private boolean isBlockCommentExists;

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                Yaml doc = super.visitDocument(document, ctx);
                if (this.nextDocNeedsNewline) {
                    this.nextDocNeedsNewline = false;
                    doc = ((Yaml.Document)doc).withPrefix("\n" + ((Yaml.Document)doc).getPrefix());
                }
                if (!this.comment.isEmpty() && !Boolean.FALSE.equals(CommentOutProperty.this.commentOutProperty)) {
                    String newPrefix = String.format("%s# %s%s%s", this.indentation, CommentOutProperty.this.commentText, this.indentation.contains("\n") ? "" : "\n", this.indentation.contains("\n") ? this.comment : this.comment.replace("#", "# "));
                    this.nextDocNeedsNewline = !newPrefix.endsWith("\n");
                    this.comment = "";
                    return document.withEnd(((Yaml.Document)doc).getEnd().withPrefix(newPrefix));
                }
                return doc;
            }

            @Override
            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                this.indentation = entry.getPrefix();
                if (Boolean.FALSE.equals(CommentOutProperty.this.commentOutProperty)) {
                    return this.addBockCommentIfNecessary(entry, ctx);
                }
                if (!this.comment.isEmpty()) {
                    String newPrefix = entry.getPrefix() + "# " + CommentOutProperty.this.commentText + this.comment + entry.getPrefix();
                    this.comment = "";
                    return entry.withPrefix(newPrefix);
                }
                return super.visitSequenceEntry(entry, ctx);
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                String lastIndentation = this.indentation;
                this.indentation = entry.getPrefix();
                if (!this.comment.isEmpty() && !Boolean.FALSE.equals(CommentOutProperty.this.commentOutProperty)) {
                    String newPrefix = entry.getPrefix() + "# " + CommentOutProperty.this.commentText + this.comment + entry.getPrefix();
                    this.comment = "";
                    return entry.withPrefix(newPrefix);
                }
                String prop = this.calculateCurrentKeyPath();
                if (prop.equals(CommentOutProperty.this.propertyKey)) {
                    String prefix = entry.getPrefix();
                    this.comment = prefix.contains("\n") ? entry.print(this.getCursor().getParentTreeCursor()).replace(prefix, prefix + "# ") : lastIndentation + "#" + entry.print(this.getCursor().getParentTreeCursor());
                    if (Boolean.FALSE.equals(CommentOutProperty.this.commentOutProperty)) {
                        if (!entry.getPrefix().contains(CommentOutProperty.this.commentText) && !this.isBlockCommentExists) {
                            return entry.withPrefix(entry.getPrefix() + "# " + CommentOutProperty.this.commentText + (entry.getPrefix().contains("\n") ? entry.getPrefix() : "\n" + entry.getPrefix()));
                        }
                    } else {
                        this.doAfterVisit(new DeleteProperty(CommentOutProperty.this.propertyKey, null, null, null).getVisitor());
                    }
                    return entry;
                }
                return super.visitMappingEntry(entry, ctx);
            }

            private Yaml.Sequence.Entry addBockCommentIfNecessary(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                boolean propertyExistsInSequence = this.isPropertyExistsInSequence(entry);
                if (propertyExistsInSequence) {
                    this.isBlockCommentExists = true;
                    if (!entry.getPrefix().contains(CommentOutProperty.this.commentText)) {
                        return entry.withPrefix(entry.getPrefix() + "# " + CommentOutProperty.this.commentText + (entry.getPrefix().contains("\n") ? entry.getPrefix() : "\n" + entry.getPrefix()));
                    }
                }
                return super.visitSequenceEntry(entry, ctx);
            }

            private boolean isPropertyExistsInSequence(Yaml.Sequence.Entry entry) {
                if (!(entry.getBlock() instanceof Yaml.Mapping)) {
                    return false;
                }
                Yaml.Mapping mapping = (Yaml.Mapping)entry.getBlock();
                String prop = this.calculateCurrentKeyPath();
                return mapping.getEntries().stream().anyMatch(e -> CommentOutProperty.this.propertyKey.equals(prop + "." + e.getKey().getValue()));
            }

            private String calculateCurrentKeyPath() {
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
            }
        };
    }

    @Generated
    public CommentOutProperty(String propertyKey, String commentText, @Nullable Boolean commentOutProperty) {
        this.propertyKey = propertyKey;
        this.commentText = commentText;
        this.commentOutProperty = commentOutProperty;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public String getCommentText() {
        return this.commentText;
    }

    @Generated
    public @Nullable Boolean getCommentOutProperty() {
        return this.commentOutProperty;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CommentOutProperty(propertyKey=" + this.getPropertyKey() + ", commentText=" + this.getCommentText() + ", commentOutProperty=" + this.getCommentOutProperty() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentOutProperty)) {
            return false;
        }
        CommentOutProperty other = (CommentOutProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$commentOutProperty = this.getCommentOutProperty();
        Boolean other$commentOutProperty = other.getCommentOutProperty();
        if (this$commentOutProperty == null ? other$commentOutProperty != null : !((Object)this$commentOutProperty).equals(other$commentOutProperty)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$commentText = this.getCommentText();
        String other$commentText = other.getCommentText();
        return !(this$commentText == null ? other$commentText != null : !this$commentText.equals(other$commentText));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CommentOutProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $commentOutProperty = this.getCommentOutProperty();
        result = result * 59 + ($commentOutProperty == null ? 43 : ((Object)$commentOutProperty).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $commentText = this.getCommentText();
        result = result * 59 + ($commentText == null ? 43 : $commentText.hashCode());
        return result;
    }
}

