/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangePropertyKey
extends Recipe {
    @Option(displayName="Old property key", example="management.metrics.binders.files.enabled")
    private final String oldPropertyKey;
    @Option(displayName="New property key", example="management.metrics.enable.process.files")
    private final String newPropertyKey;

    public String getDisplayName() {
        return "Change property key";
    }

    public String getDescription() {
        return "Change a YAML property key leaving the value intact. Nested YAML mappings are interpreted as dot separated property names, i.e. as Spring Boot interprets application.yml files.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyKeyVisitor<ExecutionContext>();
    }

    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
    }

    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKey)) {
            return false;
        }
        ChangePropertyKey other = (ChangePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        return !(this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        return result;
    }

    private static class DeletePropertyVisitor<P>
    extends YamlIsoVisitor<P> {
        private final Yaml.Mapping.Entry scope;

        private DeletePropertyVisitor(Yaml.Mapping.Entry scope) {
            this.scope = scope;
        }

        @Override
        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
            Yaml m = super.visitMapping(mapping, (Object)p);
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList();
            for (Yaml.Mapping.Entry entry : ((Yaml.Mapping)m).getEntries()) {
                if (entry == this.scope || entry.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)entry.getValue()).getEntries().isEmpty()) {
                    changed = true;
                    continue;
                }
                entries.add(entry);
            }
            if (entries.size() == 1) {
                entries = ListUtils.map(entries, e -> e.withPrefix(""));
            }
            if (changed) {
                Yaml.Document document;
                m = ((Yaml.Mapping)m).withEntries(entries);
                if (this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document && !(document = (Yaml.Document)this.getCursor().getParentOrThrow().getValue()).isExplicit()) {
                    m = ((Yaml.Mapping)m).withEntries(((Yaml.Mapping)m).getEntries());
                }
            }
            return m;
        }
    }

    private static class InsertSubpropertyVisitor<P>
    extends YamlIsoVisitor<P> {
        private final Yaml.Mapping.Entry scope;
        private final String subproperty;
        private final Yaml.Block value;

        private InsertSubpropertyVisitor(Yaml.Mapping.Entry scope, String subproperty, Yaml.Block value) {
            this.scope = scope;
            this.subproperty = subproperty;
            this.value = value;
        }

        @Override
        public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
            Yaml m = super.visitMapping(mapping, (Object)p);
            if (((Yaml.Mapping)m).getEntries().contains(this.scope)) {
                String newEntryPrefix = this.scope.getPrefix();
                if (newEntryPrefix.isEmpty()) {
                    newEntryPrefix = "\n";
                }
                m = ((Yaml.Mapping)m).withEntries(Stream.concat(((Yaml.Mapping)m).getEntries().stream(), Stream.of(new Yaml.Mapping.Entry(Tree.randomId(), newEntryPrefix, Markers.EMPTY, new Yaml.Scalar(Tree.randomId(), "", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, this.subproperty), this.scope.getBeforeMappingValueIndicator(), this.value.copyPaste()))).collect(Collectors.toList()));
            }
            return m;
        }
    }

    private class ChangePropertyKeyVisitor<P>
    extends YamlIsoVisitor<P> {
        private ChangePropertyKeyVisitor() {
        }

        @Override
        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
            Yaml e = super.visitMappingEntry(entry, (Object)p);
            Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
            String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
            String propertyToTest = ChangePropertyKey.this.newPropertyKey;
            if (prop.equals(ChangePropertyKey.this.oldPropertyKey)) {
                Iterator propertyEntriesLeftToRight = propertyEntries.descendingIterator();
                while (propertyEntriesLeftToRight.hasNext()) {
                    Yaml.Mapping.Entry propertyEntry = (Yaml.Mapping.Entry)propertyEntriesLeftToRight.next();
                    String value = propertyEntry.getKey().getValue();
                    if (!propertyToTest.startsWith(value)) {
                        this.doAfterVisit(new InsertSubpropertyVisitor(propertyEntry, propertyToTest, entry.getValue()));
                        this.doAfterVisit(new DeletePropertyVisitor(entry));
                        this.maybeCoalesceProperties();
                        break;
                    }
                    propertyToTest = propertyToTest.substring(value.length() + 1);
                }
            }
            return e;
        }
    }
}

