/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.format.TabsAndIndentsVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class TabsAndIndents
extends Recipe {
    public String getDisplayName() {
        return "Tabs and indents";
    }

    public String getDescription() {
        return "Format tabs and indents in XML code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends XmlIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)document.getStyle(TabsAndIndentsStyle.class);
            if (style == null) {
                style = TabsAndIndentsStyle.DEFAULT;
            }
            this.doAfterVisit(new TabsAndIndentsVisitor(style));
            return document;
        }
    }
}

