/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.PythonVisitor;
import org.openrewrite.python.internal.PythonPrinter;

public interface Py
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        String visitorName = v.getClass().getCanonicalName();
        if (visitorName != null && visitorName.startsWith("io.moderne.serialization.")) {
            return (R)this;
        }
        return (R)this.acceptPython((PythonVisitor)v.adapt(PythonVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(PythonVisitor.class);
    }

    @Nullable
    default public <P> J acceptPython(PythonVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class MatchCase
    implements Py,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Pattern pattern;
        @Nullable
        private final JLeftPadded<Expression> guard;
        @Nullable
        private final JavaType type;

        @Nullable
        public Expression getGuard() {
            return this.guard == null ? null : (Expression)this.guard.getElement();
        }

        public MatchCase withGuard(Expression guard) {
            return this.getPadding().withGuard((JLeftPadded<Expression>)JLeftPadded.withElement(this.guard, (Object)guard));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitMatchCase(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchCase)) {
                return false;
            }
            MatchCase other = (MatchCase)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MatchCase(UUID id, Space prefix, Markers markers, Pattern pattern, JLeftPadded<Expression> guard, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.guard = guard;
            this.type = type;
        }

        private MatchCase(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Pattern pattern, JLeftPadded<Expression> guard, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.guard = guard;
            this.type = type;
        }

        public MatchCase withId(UUID id) {
            return this.id == id ? this : new MatchCase(this.padding, id, this.prefix, this.markers, this.pattern, this.guard, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public MatchCase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MatchCase(this.padding, this.id, prefix, this.markers, this.pattern, this.guard, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public MatchCase withMarkers(Markers markers) {
            return this.markers == markers ? this : new MatchCase(this.padding, this.id, this.prefix, markers, this.pattern, this.guard, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public MatchCase withPattern(Pattern pattern) {
            return this.pattern == pattern ? this : new MatchCase(this.padding, this.id, this.prefix, this.markers, pattern, this.guard, this.type);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public MatchCase withType(JavaType type) {
            return this.type == type ? this : new MatchCase(this.padding, this.id, this.prefix, this.markers, this.pattern, this.guard, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static final class Pattern
        implements Py,
        Expression {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Kind kind;
            private final JContainer<Expression> children;
            @Nullable
            private final JavaType type;

            public List<Expression> getChildren() {
                return this.children.getElements();
            }

            public Pattern withChildren(List<Expression> children) {
                return this.getPadding().withChildren((JContainer<Expression>)JContainer.withElements(this.children, children));
            }

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitMatchCasePattern(this, p);
            }

            public CoordinateBuilder.Expression getCoordinates() {
                return new CoordinateBuilder.Expression((J)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pattern)) {
                    return false;
                }
                Pattern other = (Pattern)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Pattern(UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> children, JavaType type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.kind = kind;
                this.children = children;
                this.type = type;
            }

            private Pattern(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> children, JavaType type) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.kind = kind;
                this.children = children;
                this.type = type;
            }

            public Pattern withId(UUID id) {
                return this.id == id ? this : new Pattern(this.padding, id, this.prefix, this.markers, this.kind, this.children, this.type);
            }

            public UUID getId() {
                return this.id;
            }

            public Pattern withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Pattern(this.padding, this.id, prefix, this.markers, this.kind, this.children, this.type);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Pattern withMarkers(Markers markers) {
                return this.markers == markers ? this : new Pattern(this.padding, this.id, this.prefix, markers, this.kind, this.children, this.type);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Pattern withKind(Kind kind) {
                return this.kind == kind ? this : new Pattern(this.padding, this.id, this.prefix, this.markers, kind, this.children, this.type);
            }

            public Kind getKind() {
                return this.kind;
            }

            public Pattern withType(JavaType type) {
                return this.type == type ? this : new Pattern(this.padding, this.id, this.prefix, this.markers, this.kind, this.children, type);
            }

            public JavaType getType() {
                return this.type;
            }

            public static enum Kind {
                AS,
                CAPTURE,
                CLASS,
                DOUBLE_STAR,
                GROUP,
                KEY_VALUE,
                KEYWORD,
                LITERAL,
                MAPPING,
                OR,
                SEQUENCE,
                SEQUENCE_LIST,
                SEQUENCE_TUPLE,
                STAR,
                VALUE,
                WILDCARD;

            }

            public static class Padding {
                private final Pattern t;

                public JContainer<Expression> getChildren() {
                    return this.t.children;
                }

                public Pattern withChildren(JContainer<Expression> children) {
                    return children == this.t.children ? this.t : new Pattern(this.t.id, this.t.prefix, this.t.markers, this.t.kind, children, this.t.type);
                }

                public Padding(Pattern t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final MatchCase t;

            @Nullable
            public JLeftPadded<Expression> getGuard() {
                return this.t.guard;
            }

            public MatchCase withGuard(JLeftPadded<Expression> guard) {
                return guard == this.t.guard ? this.t : new MatchCase(this.t.id, this.t.prefix, this.t.markers, this.t.pattern, guard, null);
            }

            public Padding(MatchCase t) {
                this.t = t;
            }
        }
    }

    public static final class ErrorFromExpression
    implements Py,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression error;
        private final JLeftPadded<Expression> from;
        private final JavaType type;

        public Expression getFrom() {
            return (Expression)this.from.getElement();
        }

        public ErrorFromExpression withFrom(Expression from) {
            return this.getPadding().withFrom((JLeftPadded<Expression>)this.from.withElement((Object)from));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitErrorFromExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorFromExpression)) {
                return false;
            }
            ErrorFromExpression other = (ErrorFromExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ErrorFromExpression(UUID id, Space prefix, Markers markers, Expression error, JLeftPadded<Expression> from, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.error = error;
            this.from = from;
            this.type = type;
        }

        private ErrorFromExpression(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression error, JLeftPadded<Expression> from, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.error = error;
            this.from = from;
            this.type = type;
        }

        public ErrorFromExpression withId(UUID id) {
            return this.id == id ? this : new ErrorFromExpression(this.padding, id, this.prefix, this.markers, this.error, this.from, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public ErrorFromExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ErrorFromExpression(this.padding, this.id, prefix, this.markers, this.error, this.from, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ErrorFromExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new ErrorFromExpression(this.padding, this.id, this.prefix, markers, this.error, this.from, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ErrorFromExpression withError(Expression error) {
            return this.error == error ? this : new ErrorFromExpression(this.padding, this.id, this.prefix, this.markers, error, this.from, this.type);
        }

        public Expression getError() {
            return this.error;
        }

        public ErrorFromExpression withType(JavaType type) {
            return this.type == type ? this : new ErrorFromExpression(this.padding, this.id, this.prefix, this.markers, this.error, this.from, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ErrorFromExpression t;

            public JLeftPadded<Expression> getFrom() {
                return this.t.from;
            }

            public ErrorFromExpression withFrom(JLeftPadded<Expression> from) {
                return from == this.t.from ? this.t : new ErrorFromExpression(this.t.id, this.t.prefix, this.t.markers, this.t.error, from, this.t.type);
            }

            public Padding(ErrorFromExpression t) {
                this.t = t;
            }
        }
    }

    public static final class TypeHintedExpression
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeHint typeHint;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTypeHintedExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeHintedExpression)) {
                return false;
            }
            TypeHintedExpression other = (TypeHintedExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeHintedExpression(UUID id, Space prefix, Markers markers, TypeHint typeHint, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeHint = typeHint;
            this.expression = expression;
            this.type = type;
        }

        public TypeHintedExpression withId(UUID id) {
            return this.id == id ? this : new TypeHintedExpression(id, this.prefix, this.markers, this.typeHint, this.expression, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public TypeHintedExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeHintedExpression(this.id, prefix, this.markers, this.typeHint, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public TypeHintedExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeHintedExpression(this.id, this.prefix, markers, this.typeHint, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeHintedExpression withTypeHint(TypeHint typeHint) {
            return this.typeHint == typeHint ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, typeHint, this.expression, this.type);
        }

        public TypeHint getTypeHint() {
            return this.typeHint;
        }

        public TypeHintedExpression withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, this.typeHint, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public TypeHintedExpression withType(JavaType type) {
            return this.type == type ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, this.typeHint, this.expression, type);
        }

        public JavaType getType() {
            return this.type;
        }
    }

    public static final class NamedArgument
    implements Py,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.Identifier name;
        private final JLeftPadded<Expression> value;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitNamedArgument(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedArgument)) {
                return false;
            }
            NamedArgument other = (NamedArgument)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NamedArgument(UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<Expression> value, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        private NamedArgument(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<Expression> value, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public NamedArgument withId(UUID id) {
            return this.id == id ? this : new NamedArgument(this.padding, id, this.prefix, this.markers, this.name, this.value, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public NamedArgument withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamedArgument(this.padding, this.id, prefix, this.markers, this.name, this.value, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public NamedArgument withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamedArgument(this.padding, this.id, this.prefix, markers, this.name, this.value, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public NamedArgument withName(J.Identifier name) {
            return this.name == name ? this : new NamedArgument(this.padding, this.id, this.prefix, this.markers, name, this.value, this.type);
        }

        public J.Identifier getName() {
            return this.name;
        }

        public NamedArgument withType(JavaType type) {
            return this.type == type ? this : new NamedArgument(this.padding, this.id, this.prefix, this.markers, this.name, this.value, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NamedArgument t;

            public JLeftPadded<Expression> getValue() {
                return this.t.value;
            }

            public NamedArgument withFrom(JLeftPadded<Expression> value) {
                return value == this.t.value ? this.t : new NamedArgument(this.t.id, this.t.prefix, this.t.markers, this.t.name, value, this.t.type);
            }

            public Padding(NamedArgument t) {
                this.t = t;
            }
        }
    }

    public static final class SpecialArgument
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitSpecialArgument(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecialArgument)) {
                return false;
            }
            SpecialArgument other = (SpecialArgument)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public SpecialArgument(UUID id, Space prefix, Markers markers, Kind kind, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.expression = expression;
            this.type = type;
        }

        public SpecialArgument withId(UUID id) {
            return this.id == id ? this : new SpecialArgument(id, this.prefix, this.markers, this.kind, this.expression, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public SpecialArgument withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpecialArgument(this.id, prefix, this.markers, this.kind, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public SpecialArgument withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpecialArgument(this.id, this.prefix, markers, this.kind, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public SpecialArgument withKind(Kind kind) {
            return this.kind == kind ? this : new SpecialArgument(this.id, this.prefix, this.markers, kind, this.expression, this.type);
        }

        public Kind getKind() {
            return this.kind;
        }

        public SpecialArgument withExpression(Expression expression) {
            return this.expression == expression ? this : new SpecialArgument(this.id, this.prefix, this.markers, this.kind, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public SpecialArgument withType(JavaType type) {
            return this.type == type ? this : new SpecialArgument(this.id, this.prefix, this.markers, this.kind, this.expression, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static enum Kind {
            KWARGS,
            ARGS;

        }
    }

    public static final class SpecialParameter
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        @Nullable
        private final TypeHint typeHint;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitSpecialParameter(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecialParameter)) {
                return false;
            }
            SpecialParameter other = (SpecialParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public SpecialParameter(UUID id, Space prefix, Markers markers, Kind kind, TypeHint typeHint, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.typeHint = typeHint;
            this.type = type;
        }

        public SpecialParameter withId(UUID id) {
            return this.id == id ? this : new SpecialParameter(id, this.prefix, this.markers, this.kind, this.typeHint, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public SpecialParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpecialParameter(this.id, prefix, this.markers, this.kind, this.typeHint, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public SpecialParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpecialParameter(this.id, this.prefix, markers, this.kind, this.typeHint, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public SpecialParameter withKind(Kind kind) {
            return this.kind == kind ? this : new SpecialParameter(this.id, this.prefix, this.markers, kind, this.typeHint, this.type);
        }

        public Kind getKind() {
            return this.kind;
        }

        public SpecialParameter withTypeHint(TypeHint typeHint) {
            return this.typeHint == typeHint ? this : new SpecialParameter(this.id, this.prefix, this.markers, this.kind, typeHint, this.type);
        }

        public TypeHint getTypeHint() {
            return this.typeHint;
        }

        public SpecialParameter withType(JavaType type) {
            return this.type == type ? this : new SpecialParameter(this.id, this.prefix, this.markers, this.kind, this.typeHint, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static enum Kind {
            KWARGS,
            ARGS;

        }
    }

    public static final class DelStatement
    implements Py,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> targets;

        public List<Expression> getTargets() {
            return JRightPadded.getElements(this.targets);
        }

        public DelStatement withTargets(List<Expression> expressions) {
            return this.getPadding().withTargets(JRightPadded.withElements(this.targets, expressions));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitDelStatement(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DelStatement)) {
                return false;
            }
            DelStatement other = (DelStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DelStatement(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> targets) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.targets = targets;
        }

        private DelStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> targets) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.targets = targets;
        }

        public DelStatement withId(UUID id) {
            return this.id == id ? this : new DelStatement(this.padding, id, this.prefix, this.markers, this.targets);
        }

        public UUID getId() {
            return this.id;
        }

        public DelStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DelStatement(this.padding, this.id, prefix, this.markers, this.targets);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public DelStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new DelStatement(this.padding, this.id, this.prefix, markers, this.targets);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final DelStatement t;

            public List<JRightPadded<Expression>> getTargets() {
                return this.t.targets;
            }

            public DelStatement withTargets(List<JRightPadded<Expression>> expressions) {
                return expressions == this.t.targets ? this.t : new DelStatement(this.t.id, this.t.prefix, this.t.markers, expressions);
            }

            public Padding(DelStatement t) {
                this.t = t;
            }
        }
    }

    public static final class AssertStatement
    implements Py,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> expressions;

        public List<Expression> getExpressions() {
            return JRightPadded.getElements(this.expressions);
        }

        public AssertStatement withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions(JRightPadded.withElements(this.expressions, expressions));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitAssertStatement(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssertStatement)) {
                return false;
            }
            AssertStatement other = (AssertStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AssertStatement(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> expressions) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
        }

        private AssertStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> expressions) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
        }

        public AssertStatement withId(UUID id) {
            return this.id == id ? this : new AssertStatement(this.padding, id, this.prefix, this.markers, this.expressions);
        }

        public UUID getId() {
            return this.id;
        }

        public AssertStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssertStatement(this.padding, this.id, prefix, this.markers, this.expressions);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public AssertStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssertStatement(this.padding, this.id, this.prefix, markers, this.expressions);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final AssertStatement t;

            public List<JRightPadded<Expression>> getExpressions() {
                return this.t.expressions;
            }

            public AssertStatement withExpressions(List<JRightPadded<Expression>> expressions) {
                return expressions == this.t.expressions ? this.t : new AssertStatement(this.t.id, this.t.prefix, this.t.markers, expressions);
            }

            public Padding(AssertStatement t) {
                this.t = t;
            }
        }
    }

    public static final class VariableScopeStatement
    implements Py,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final List<JRightPadded<J.Identifier>> names;

        public List<J.Identifier> getNames() {
            return JRightPadded.getElements(this.names);
        }

        public VariableScopeStatement withNames(List<J.Identifier> names) {
            return this.getPadding().withNames(JRightPadded.withElements(this.names, names));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitVariableScopeStatement(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableScopeStatement)) {
                return false;
            }
            VariableScopeStatement other = (VariableScopeStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public VariableScopeStatement(UUID id, Space prefix, Markers markers, Kind kind, List<JRightPadded<J.Identifier>> names) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.names = names;
        }

        private VariableScopeStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Kind kind, List<JRightPadded<J.Identifier>> names) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.names = names;
        }

        public VariableScopeStatement withId(UUID id) {
            return this.id == id ? this : new VariableScopeStatement(this.padding, id, this.prefix, this.markers, this.kind, this.names);
        }

        public UUID getId() {
            return this.id;
        }

        public VariableScopeStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableScopeStatement(this.padding, this.id, prefix, this.markers, this.kind, this.names);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public VariableScopeStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableScopeStatement(this.padding, this.id, this.prefix, markers, this.kind, this.names);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public VariableScopeStatement withKind(Kind kind) {
            return this.kind == kind ? this : new VariableScopeStatement(this.padding, this.id, this.prefix, this.markers, kind, this.names);
        }

        public Kind getKind() {
            return this.kind;
        }

        public static enum Kind {
            GLOBAL,
            NONLOCAL;

        }

        public static class Padding {
            private final VariableScopeStatement t;

            public List<JRightPadded<J.Identifier>> getNames() {
                return this.t.names;
            }

            public VariableScopeStatement withNames(List<JRightPadded<J.Identifier>> names) {
                return names == this.t.names ? this.t : new VariableScopeStatement(this.t.id, this.t.prefix, this.t.markers, this.t.kind, names);
            }

            public Padding(VariableScopeStatement t) {
                this.t = t;
            }
        }
    }

    public static final class YieldExpression
    implements Py,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> from;
        private final List<JRightPadded<Expression>> expressions;
        private final JavaType type;

        public boolean isFrom() {
            return (Boolean)this.from.getElement();
        }

        public YieldExpression withFrom(boolean from) {
            return this.getPadding().withFrom((JLeftPadded<Boolean>)JLeftPadded.withElement(this.from, (Object)from));
        }

        public List<Expression> getExpressions() {
            return JRightPadded.getElements(this.expressions);
        }

        public YieldExpression withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions(JRightPadded.withElements(this.expressions, expressions));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitYieldExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof YieldExpression)) {
                return false;
            }
            YieldExpression other = (YieldExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public YieldExpression(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> from, List<JRightPadded<Expression>> expressions, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.expressions = expressions;
            this.type = type;
        }

        private YieldExpression(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> from, List<JRightPadded<Expression>> expressions, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.expressions = expressions;
            this.type = type;
        }

        public YieldExpression withId(UUID id) {
            return this.id == id ? this : new YieldExpression(this.padding, id, this.prefix, this.markers, this.from, this.expressions, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public YieldExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new YieldExpression(this.padding, this.id, prefix, this.markers, this.from, this.expressions, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public YieldExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new YieldExpression(this.padding, this.id, this.prefix, markers, this.from, this.expressions, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public YieldExpression withType(JavaType type) {
            return this.type == type ? this : new YieldExpression(this.padding, this.id, this.prefix, this.markers, this.from, this.expressions, type);
        }

        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final YieldExpression t;

            public JLeftPadded<Boolean> getFrom() {
                return this.t.from;
            }

            public YieldExpression withFrom(JLeftPadded<Boolean> from) {
                return from == this.t.from ? this.t : new YieldExpression(this.t.id, this.t.prefix, this.t.markers, from, this.t.expressions, this.t.type);
            }

            public List<JRightPadded<Expression>> getExpressions() {
                return this.t.expressions;
            }

            public YieldExpression withExpressions(List<JRightPadded<Expression>> expressions) {
                return expressions == this.t.expressions ? this.t : new YieldExpression(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<Boolean>)this.t.from, expressions, this.t.type);
            }

            public Padding(YieldExpression t) {
                this.t = t;
            }
        }
    }

    public static final class AwaitExpression
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitAwaitExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwaitExpression)) {
                return false;
            }
            AwaitExpression other = (AwaitExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AwaitExpression(UUID id, Space prefix, Markers markers, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        public AwaitExpression withId(UUID id) {
            return this.id == id ? this : new AwaitExpression(id, this.prefix, this.markers, this.expression, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public AwaitExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AwaitExpression(this.id, prefix, this.markers, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public AwaitExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new AwaitExpression(this.id, this.prefix, markers, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public AwaitExpression withExpression(Expression expression) {
            return this.expression == expression ? this : new AwaitExpression(this.id, this.prefix, this.markers, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public AwaitExpression withType(JavaType type) {
            return this.type == type ? this : new AwaitExpression(this.id, this.prefix, this.markers, this.expression, type);
        }

        public JavaType getType() {
            return this.type;
        }
    }

    public static final class ComprehensionExpression
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final Expression result;
        private final List<Clause> clauses;
        private final Space suffix;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitComprehensionExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComprehensionExpression)) {
                return false;
            }
            ComprehensionExpression other = (ComprehensionExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ComprehensionExpression(UUID id, Space prefix, Markers markers, Kind kind, Expression result, List<Clause> clauses, Space suffix, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.result = result;
            this.clauses = clauses;
            this.suffix = suffix;
            this.type = type;
        }

        public ComprehensionExpression withId(UUID id) {
            return this.id == id ? this : new ComprehensionExpression(id, this.prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        public ComprehensionExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ComprehensionExpression(this.id, prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ComprehensionExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new ComprehensionExpression(this.id, this.prefix, markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ComprehensionExpression withKind(Kind kind) {
            return this.kind == kind ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, kind, this.result, this.clauses, this.suffix, this.type);
        }

        public Kind getKind() {
            return this.kind;
        }

        public ComprehensionExpression withResult(Expression result) {
            return this.result == result ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, result, this.clauses, this.suffix, this.type);
        }

        public Expression getResult() {
            return this.result;
        }

        public List<Clause> getClauses() {
            return this.clauses;
        }

        public ComprehensionExpression withClauses(List<Clause> clauses) {
            return this.clauses == clauses ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, clauses, this.suffix, this.type);
        }

        public ComprehensionExpression withSuffix(Space suffix) {
            return this.suffix == suffix ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, this.clauses, suffix, this.type);
        }

        public Space getSuffix() {
            return this.suffix;
        }

        public JavaType getType() {
            return this.type;
        }

        public ComprehensionExpression withType(JavaType type) {
            return this.type == type ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, type);
        }

        public static enum Kind {
            LIST,
            SET,
            DICT,
            GENERATOR;

        }

        public static final class Clause
        implements Py {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Expression iteratorVariable;
            private final JLeftPadded<Expression> iteratedList;
            @Nullable
            private final List<Condition> conditions;

            public Expression getIteratedList() {
                return (Expression)this.iteratedList.getElement();
            }

            public Clause withIteratedList(Expression expression) {
                return this.getPadding().withIteratedList((JLeftPadded<Expression>)this.iteratedList.withElement((Object)expression));
            }

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitComprehensionClause(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Clause)) {
                    return false;
                }
                Clause other = (Clause)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Clause(UUID id, Space prefix, Markers markers, Expression iteratorVariable, JLeftPadded<Expression> iteratedList, List<Condition> conditions) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.iteratorVariable = iteratorVariable;
                this.iteratedList = iteratedList;
                this.conditions = conditions;
            }

            private Clause(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression iteratorVariable, JLeftPadded<Expression> iteratedList, List<Condition> conditions) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.iteratorVariable = iteratorVariable;
                this.iteratedList = iteratedList;
                this.conditions = conditions;
            }

            public Clause withId(UUID id) {
                return this.id == id ? this : new Clause(this.padding, id, this.prefix, this.markers, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            public UUID getId() {
                return this.id;
            }

            public Clause withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Clause(this.padding, this.id, prefix, this.markers, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Clause withMarkers(Markers markers) {
                return this.markers == markers ? this : new Clause(this.padding, this.id, this.prefix, markers, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Clause withIteratorVariable(Expression iteratorVariable) {
                return this.iteratorVariable == iteratorVariable ? this : new Clause(this.padding, this.id, this.prefix, this.markers, iteratorVariable, this.iteratedList, this.conditions);
            }

            public Expression getIteratorVariable() {
                return this.iteratorVariable;
            }

            public Clause withConditions(List<Condition> conditions) {
                return this.conditions == conditions ? this : new Clause(this.padding, this.id, this.prefix, this.markers, this.iteratorVariable, this.iteratedList, conditions);
            }

            public List<Condition> getConditions() {
                return this.conditions;
            }

            public static class Padding {
                private final Clause t;

                public JLeftPadded<Expression> getIteratedList() {
                    return this.t.iteratedList;
                }

                public Clause withIteratedList(JLeftPadded<Expression> iteratedList) {
                    return this.t.iteratedList == iteratedList ? this.t : new Clause(this.t.id, this.t.prefix, this.t.markers, this.t.iteratorVariable, iteratedList, this.t.conditions);
                }

                public Padding(Clause t) {
                    this.t = t;
                }
            }
        }

        public static final class Condition
        implements Py {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Expression expression;

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitComprehensionCondition(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Condition)) {
                    return false;
                }
                Condition other = (Condition)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Condition(UUID id, Space prefix, Markers markers, Expression expression) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.expression = expression;
            }

            public Condition withId(UUID id) {
                return this.id == id ? this : new Condition(id, this.prefix, this.markers, this.expression);
            }

            public UUID getId() {
                return this.id;
            }

            public Condition withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Condition(this.id, prefix, this.markers, this.expression);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Condition withMarkers(Markers markers) {
                return this.markers == markers ? this : new Condition(this.id, this.prefix, markers, this.expression);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Condition withExpression(Expression expression) {
                return this.expression == expression ? this : new Condition(this.id, this.prefix, this.markers, expression);
            }

            public Expression getExpression() {
                return this.expression;
            }
        }
    }

    public static final class TrailingElseWrapper
    implements Py,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Statement statement;
        private final JLeftPadded<J.Block> elseBlock;

        public J.Block getElseBlock() {
            return (J.Block)this.elseBlock.getElement();
        }

        public TrailingElseWrapper withElseBlock(J.Block elseBlock) {
            return this.getPadding().withElseBlock((JLeftPadded<J.Block>)JLeftPadded.withElement(this.elseBlock, (Object)elseBlock));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTrailingElseWrapper(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "Py.TrailingElseWrapper(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statement=" + this.getStatement() + ", elseBlock=" + this.getElseBlock() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof TrailingElseWrapper;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public TrailingElseWrapper(UUID id, Space prefix, Markers markers, Statement statement, JLeftPadded<J.Block> elseBlock) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statement = statement;
            this.elseBlock = elseBlock;
        }

        private TrailingElseWrapper(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Statement statement, JLeftPadded<J.Block> elseBlock) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statement = statement;
            this.elseBlock = elseBlock;
        }

        public TrailingElseWrapper withId(UUID id) {
            return this.id == id ? this : new TrailingElseWrapper(this.padding, id, this.prefix, this.markers, this.statement, this.elseBlock);
        }

        public UUID getId() {
            return this.id;
        }

        public TrailingElseWrapper withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TrailingElseWrapper(this.padding, this.id, prefix, this.markers, this.statement, this.elseBlock);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public TrailingElseWrapper withMarkers(Markers markers) {
            return this.markers == markers ? this : new TrailingElseWrapper(this.padding, this.id, this.prefix, markers, this.statement, this.elseBlock);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TrailingElseWrapper withStatement(Statement statement) {
            return this.statement == statement ? this : new TrailingElseWrapper(this.padding, this.id, this.prefix, this.markers, statement, this.elseBlock);
        }

        public Statement getStatement() {
            return this.statement;
        }

        public static class Padding {
            private final TrailingElseWrapper t;

            public JLeftPadded<J.Block> getElseBlock() {
                return this.t.elseBlock;
            }

            public TrailingElseWrapper withElseBlock(JLeftPadded<J.Block> elseBlock) {
                return this.t.elseBlock == elseBlock ? this.t : new TrailingElseWrapper(this.t.padding, this.t.id, this.t.prefix, this.t.markers, this.t.statement, elseBlock);
            }

            public Padding(TrailingElseWrapper t) {
                this.t = t;
            }
        }
    }

    public static final class PassStatement
    implements Py,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitPassStatement(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return "Py.PassStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof PassStatement;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public PassStatement(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public PassStatement withId(UUID id) {
            return this.id == id ? this : new PassStatement(id, this.prefix, this.markers);
        }

        public UUID getId() {
            return this.id;
        }

        public PassStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new PassStatement(this.id, prefix, this.markers);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public PassStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new PassStatement(this.id, this.prefix, markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class DictLiteral
    implements Py,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<KeyValue> elements;
        @Nullable
        private final JavaType type;

        public List<KeyValue> getElements() {
            return this.elements.getElements();
        }

        public DictLiteral withElements(List<KeyValue> elements) {
            return this.getPadding().withElements((JContainer<KeyValue>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitDictLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DictLiteral)) {
                return false;
            }
            DictLiteral other = (DictLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DictLiteral(UUID id, Space prefix, Markers markers, JContainer<KeyValue> elements, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private DictLiteral(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<KeyValue> elements, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public DictLiteral withId(UUID id) {
            return this.id == id ? this : new DictLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public DictLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DictLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public DictLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new DictLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        public JavaType getType() {
            return this.type;
        }

        public DictLiteral withType(JavaType type) {
            return this.type == type ? this : new DictLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final DictLiteral t;

            public JContainer<KeyValue> getElements() {
                return this.t.elements;
            }

            public DictLiteral withElements(JContainer<KeyValue> elements) {
                return this.t.elements == elements ? this.t : new DictLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(DictLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class KeyValue
    implements Py,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> key;
        private final Expression value;
        @Nullable
        private final JavaType type;

        public Expression getKey() {
            return (Expression)this.key.getElement();
        }

        public KeyValue withKey(@Nullable Expression key) {
            return this.getPadding().withKey((JRightPadded<Expression>)JRightPadded.withElement(this.key, (Object)key));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitKeyValue(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public KeyValue(UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        private KeyValue(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public KeyValue withId(UUID id) {
            return this.id == id ? this : new KeyValue(this.padding, id, this.prefix, this.markers, this.key, this.value, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public KeyValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KeyValue(this.padding, this.id, prefix, this.markers, this.key, this.value, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public KeyValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new KeyValue(this.padding, this.id, this.prefix, markers, this.key, this.value, this.type);
        }

        public Expression getValue() {
            return this.value;
        }

        public KeyValue withValue(Expression value) {
            return this.value == value ? this : new KeyValue(this.padding, this.id, this.prefix, this.markers, this.key, value, this.type);
        }

        public JavaType getType() {
            return this.type;
        }

        public KeyValue withType(JavaType type) {
            return this.type == type ? this : new KeyValue(this.padding, this.id, this.prefix, this.markers, this.key, this.value, type);
        }

        public static class Padding {
            private final KeyValue t;

            @Nullable
            public JRightPadded<Expression> getKey() {
                return this.t.key;
            }

            public KeyValue withKey(@Nullable JRightPadded<Expression> key) {
                return this.t.key == key ? this.t : new KeyValue(this.t.id, this.t.prefix, this.t.markers, key, this.t.value, this.t.type);
            }

            public Padding(KeyValue t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements Py,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <P2 extends J> P2 withPrefix(Space space) {
            return (P2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <P2 extends Tree> P2 withMarkers(Markers markers) {
            return (P2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return "Py.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        public UUID getId() {
            return this.id;
        }

        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }

        public Expression getExpression() {
            return this.expression;
        }
    }

    public static final class CompilationUnit
    implements Py,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PythonPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        @Nullable
        public J.Package getPackageDeclaration() {
            return null;
        }

        public JavaSourceFile withPackageDeclaration(J.Package pkg) {
            throw new IllegalStateException("Python does not support package declarations");
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "Py.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(SoftReference<TypesInUse> typesInUse, WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.imports, this.statements, this.eof);
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.imports, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }

    public static final class TypeHint
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final Expression expression;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTypeHint(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeHint)) {
                return false;
            }
            TypeHint other = (TypeHint)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeHint(UUID id, Space prefix, Markers markers, Kind kind, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.expression = expression;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeHint withId(UUID id) {
            return this.id == id ? this : new TypeHint(id, this.prefix, this.markers, this.kind, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public TypeHint withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeHint(this.id, prefix, this.markers, this.kind, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeHint withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeHint(this.id, this.prefix, markers, this.kind, this.expression, this.type);
        }

        public Kind getKind() {
            return this.kind;
        }

        public TypeHint withKind(Kind kind) {
            return this.kind == kind ? this : new TypeHint(this.id, this.prefix, this.markers, kind, this.expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public TypeHint withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeHint(this.id, this.prefix, this.markers, this.kind, expression, this.type);
        }

        public JavaType getType() {
            return this.type;
        }

        public TypeHint withType(JavaType type) {
            return this.type == type ? this : new TypeHint(this.id, this.prefix, this.markers, this.kind, this.expression, type);
        }

        public static enum Kind {
            RETURN_TYPE,
            VARIABLE_TYPE;

        }
    }

    public static final class ExceptionType
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType type;
        private final boolean isExceptionGroup;
        private final Expression expression;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitExceptionType(this, p);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionType)) {
                return false;
            }
            ExceptionType other = (ExceptionType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ExceptionType(UUID id, Space prefix, Markers markers, JavaType type, boolean isExceptionGroup, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.isExceptionGroup = isExceptionGroup;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JavaType getType() {
            return this.type;
        }

        public boolean isExceptionGroup() {
            return this.isExceptionGroup;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String toString() {
            return "Py.ExceptionType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + this.getType() + ", isExceptionGroup=" + this.isExceptionGroup() + ", expression=" + this.getExpression() + ")";
        }

        public ExceptionType withId(UUID id) {
            return this.id == id ? this : new ExceptionType(id, this.prefix, this.markers, this.type, this.isExceptionGroup, this.expression);
        }

        public ExceptionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExceptionType(this.id, prefix, this.markers, this.type, this.isExceptionGroup, this.expression);
        }

        public ExceptionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExceptionType(this.id, this.prefix, markers, this.type, this.isExceptionGroup, this.expression);
        }

        public ExceptionType withType(JavaType type) {
            return this.type == type ? this : new ExceptionType(this.id, this.prefix, this.markers, type, this.isExceptionGroup, this.expression);
        }

        public ExceptionType withExceptionGroup(boolean isExceptionGroup) {
            return this.isExceptionGroup == isExceptionGroup ? this : new ExceptionType(this.id, this.prefix, this.markers, this.type, isExceptionGroup, this.expression);
        }

        public ExceptionType withExpression(Expression expression) {
            return this.expression == expression ? this : new ExceptionType(this.id, this.prefix, this.markers, this.type, this.isExceptionGroup, expression);
        }
    }
}

