/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.python.marker.PythonVersion;
import org.openrewrite.python.table.PythonSourceFile;
import org.openrewrite.python.tree.Py;
import org.openrewrite.quark.Quark;
import org.openrewrite.text.PlainText;

public final class FindPythonSources
extends Recipe {
    private final transient PythonSourceFile pythonSourceFile = new PythonSourceFile(this);

    public String getDisplayName() {
        return "Find Python sources and collect data metrics";
    }

    public String getDescription() {
        return "Use data table to collect source files types and counts of files with extensions `.py`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (sourceFile.getSourcePath().toString().endsWith(".py")) {
                    PythonSourceFile.SourceFileType sourceFileType = null;
                    String languageLevel = "";
                    if (sourceFile instanceof Py.CompilationUnit) {
                        PythonVersion level = sourceFile.getMarkers().findFirst(PythonVersion.class).orElse(null);
                        languageLevel = level == null ? "Not found" : level.getLanguageLevel().name();
                        sourceFileType = PythonSourceFile.SourceFileType.Python;
                    } else if (sourceFile instanceof Quark) {
                        sourceFileType = PythonSourceFile.SourceFileType.Quark;
                    } else if (sourceFile instanceof PlainText) {
                        sourceFileType = PythonSourceFile.SourceFileType.PlainText;
                    }
                    FindPythonSources.this.pythonSourceFile.insertRow(ctx, new PythonSourceFile.Row(sourceFile.getSourcePath().toString(), sourceFileType, languageLevel));
                    return SearchResult.found((Tree)sourceFile);
                }
                return sourceFile;
            }
        };
    }

    public PythonSourceFile getPythonSourceFile() {
        return this.pythonSourceFile;
    }

    public String toString() {
        return "FindPythonSources(pythonSourceFile=" + (Object)((Object)this.getPythonSourceFile()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPythonSources)) {
            return false;
        }
        FindPythonSources other = (FindPythonSources)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindPythonSources;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

