/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output.support;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.support.AbstractOutputProcessor;
import org.jdom.output.support.FormatStack;
import org.jdom.output.support.Walker;
import org.jdom.output.support.XMLOutputProcessor;
import org.jdom.output.support.XmlOutputProcessorImpl;
import org.jdom.util.NamespaceStack;

public final class XmlOutputProcessorImpl
extends AbstractOutputProcessor
implements XMLOutputProcessor {
    private static final String CDATAPRE = "<![CDATA[";
    private static final String CDATAPOST = "]]>";

    @Override
    public void process(Writer out, Format format, Document doc) throws IOException {
        this.printDocument(out, new FormatStack(format), new NamespaceStack(), doc);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, DocType doctype) throws IOException {
        this.printDocType(out, new FormatStack(format), doctype);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Element element) throws IOException {
        this.printElement(out, new FormatStack(format), new NamespaceStack(), element);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, List<? extends Content> list) throws IOException {
        FormatStack fstack = new FormatStack(format);
        Walker walker = this.buildWalker(fstack, list, true);
        this.printContent(out, fstack, new NamespaceStack(), walker);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, CDATA cdata) throws IOException {
        FormatStack fstack = new FormatStack(format);
        List<CDATA> list = Collections.singletonList(cdata);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            this.printContent(out, fstack, new NamespaceStack(), walker);
        }
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Text text) throws IOException {
        FormatStack fstack = new FormatStack(format);
        List<Text> list = Collections.singletonList(text);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            this.printContent(out, fstack, new NamespaceStack(), walker);
        }
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, Comment comment) throws IOException {
        this.printComment(out, comment);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, ProcessingInstruction pi) throws IOException {
        FormatStack stack = new FormatStack(format);
        stack.setIgnoreTrAXEscapingPIs(true);
        this.printProcessingInstruction(out, stack, pi);
        out.flush();
    }

    @Override
    public void process(Writer out, Format format, EntityRef entity) throws IOException {
        this.printEntityRef(out, entity);
        out.flush();
    }

    private void write(Writer out, String str) throws IOException {
        if (str == null) {
            return;
        }
        out.write(str);
    }

    private void write(Writer out, char c) throws IOException {
        out.write(c);
    }

    private void attributeEscapedEntitiesFilter(Writer out, FormatStack fstack, String value) throws IOException {
        if (!fstack.getEscapeOutput()) {
            this.write(out, value);
            return;
        }
        this.write(out, Format.escapeAttribute(fstack.getEscapeStrategy(), value));
    }

    private void textRaw(Writer out, String str) throws IOException {
        this.write(out, str);
    }

    private void textRaw(Writer out, char ch) throws IOException {
        this.write(out, ch);
    }

    private void textEntityRef(Writer out, String name) throws IOException {
        this.textRaw(out, '&');
        this.textRaw(out, name);
        this.textRaw(out, ';');
    }

    private void textCDATA(Writer out, String text) throws IOException {
        this.textRaw(out, CDATAPRE);
        this.textRaw(out, text);
        this.textRaw(out, CDATAPOST);
    }

    private void printDocument(Writer out, FormatStack fstack, NamespaceStack nstack, Document doc) throws IOException {
        ArrayList<Content> list;
        ArrayList<Content> arrayList = list = doc.hasRootElement() ? doc.getContent() : new ArrayList<Content>(doc.getContentSize());
        if (list.isEmpty()) {
            int sz = doc.getContentSize();
            for (int i = 0; i < sz; ++i) {
                list.add(doc.getContent(i));
            }
        }
        this.printDeclaration(out, fstack);
        Walker walker = this.buildWalker(fstack, list, true);
        if (walker.hasNext()) {
            while (walker.hasNext()) {
                String padding;
                Content c = walker.next();
                if (c == null) {
                    padding = walker.text();
                    if (padding == null || !Verifier.isAllXMLWhitespace((String)padding) || walker.isCDATA()) continue;
                    this.write(out, padding);
                    continue;
                }
                switch (1.$SwitchMap$org$jdom$Content$CType[c.getCType().ordinal()]) {
                    case 1: {
                        this.printDocType(out, fstack, (DocType)c);
                        break;
                    }
                    case 2: {
                        this.printElement(out, fstack, nstack, (Element)c);
                        break;
                    }
                    case 3: {
                        padding = ((Text)c).getText();
                        if (padding == null || !Verifier.isAllXMLWhitespace((String)padding)) break;
                        this.write(out, padding);
                    }
                }
            }
            if (fstack.getLineSeparator() != null) {
                this.write(out, fstack.getLineSeparator());
            }
        }
    }

    private void printDeclaration(Writer out, FormatStack fstack) throws IOException {
        if (fstack.isOmitDeclaration()) {
            return;
        }
        if (fstack.isOmitEncoding()) {
            this.write(out, "<?xml version=\"1.0\"?>");
        } else {
            this.write(out, "<?xml version=\"1.0\"");
            this.write(out, " encoding=\"");
            this.write(out, fstack.getEncoding());
            this.write(out, "\"?>");
        }
        this.write(out, fstack.getLineSeparator());
    }

    private void printDocType(Writer out, FormatStack fstack, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        this.write(out, "<!DOCTYPE ");
        this.write(out, docType.getElementName());
        if (publicID != null) {
            this.write(out, " PUBLIC \"");
            this.write(out, publicID);
            this.write(out, "\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                this.write(out, " SYSTEM");
            }
            this.write(out, " \"");
            this.write(out, systemID);
            this.write(out, "\"");
        }
        if (internalSubset != null && !internalSubset.isEmpty()) {
            this.write(out, " [");
            this.write(out, fstack.getLineSeparator());
            this.write(out, docType.getInternalSubset());
            this.write(out, "]");
        }
        this.write(out, ">");
    }

    private void printProcessingInstruction(Writer out, FormatStack fstack, ProcessingInstruction pi) throws IOException {
        String target = pi.getTarget();
        boolean piProcessed = false;
        if (!fstack.isIgnoreTrAXEscapingPIs()) {
            if (target.equals("javax.xml.transform.disable-output-escaping")) {
                fstack.setEscapeOutput(false);
                piProcessed = true;
            } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
                fstack.setEscapeOutput(true);
                piProcessed = true;
            }
        }
        if (!piProcessed) {
            String rawData = pi.getData();
            if (!"".equals(rawData)) {
                this.write(out, "<?");
                this.write(out, target);
                this.write(out, " ");
                this.write(out, rawData);
                this.write(out, "?>");
            } else {
                this.write(out, "<?");
                this.write(out, target);
                this.write(out, "?>");
            }
        }
    }

    private void printComment(Writer out, Comment comment) throws IOException {
        this.write(out, "<!--");
        this.write(out, comment.getText());
        this.write(out, "-->");
    }

    private void printEntityRef(Writer out, EntityRef entity) throws IOException {
        this.textEntityRef(out, entity.getName());
    }

    private void printCDATA(Writer out, CDATA cdata) throws IOException {
        this.textCDATA(out, cdata.getText());
    }

    private void printText(Writer out, FormatStack fstack, Text text) throws IOException {
        if (fstack.getEscapeOutput()) {
            this.textRaw(out, Format.escapeText(fstack.getEscapeStrategy(), fstack.getLineSeparator(), text.getText()));
            return;
        }
        this.textRaw(out, text.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        nstack.push(element);
        try {
            List<Content> content = element.getContent();
            this.write(out, "<");
            this.write(out, element.getQualifiedName());
            for (Namespace ns : nstack.addedForward()) {
                this.printNamespace(out, fstack, ns);
            }
            if (element.hasAttributes()) {
                for (Attribute attribute : element.getAttributes()) {
                    this.printAttribute(out, fstack, attribute);
                }
            }
            if (content.isEmpty()) {
                if (fstack.isExpandEmptyElements()) {
                    this.write(out, "></");
                    this.write(out, element.getQualifiedName());
                    this.write(out, ">");
                } else {
                    this.write(out, " />");
                }
                return;
            }
            fstack.push();
            try {
                String space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
                if ("default".equals(space)) {
                    fstack.setTextMode(fstack.getDefaultMode());
                } else if ("preserve".equals(space)) {
                    fstack.setTextMode(Format.TextMode.PRESERVE);
                }
                Walker walker = this.buildWalker(fstack, content, true);
                if (!walker.hasNext()) {
                    if (fstack.isExpandEmptyElements()) {
                        this.write(out, "></");
                        this.write(out, element.getQualifiedName());
                        this.write(out, ">");
                    } else {
                        this.write(out, " />");
                    }
                    return;
                }
                this.write(out, ">");
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadBetween());
                }
                this.printContent(out, fstack, nstack, walker);
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadLast());
                }
                this.write(out, "</");
                this.write(out, element.getQualifiedName());
                this.write(out, ">");
            }
            finally {
                fstack.pop();
            }
        }
        finally {
            nstack.pop();
        }
    }

    private void printContent(Writer out, FormatStack fstack, NamespaceStack nstack, Walker walker) throws IOException {
        while (walker.hasNext()) {
            Content c = walker.next();
            if (c == null) {
                String t = walker.text();
                if (walker.isCDATA()) {
                    this.textCDATA(out, t);
                    continue;
                }
                this.textRaw(out, t);
                continue;
            }
            switch (1.$SwitchMap$org$jdom$Content$CType[c.getCType().ordinal()]) {
                case 4: {
                    this.printCDATA(out, (CDATA)c);
                    break;
                }
                case 5: {
                    this.printComment(out, (Comment)c);
                    break;
                }
                case 1: {
                    this.printDocType(out, fstack, (DocType)c);
                    break;
                }
                case 2: {
                    this.printElement(out, fstack, nstack, (Element)c);
                    break;
                }
                case 6: {
                    this.printEntityRef(out, (EntityRef)c);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction(out, fstack, (ProcessingInstruction)c);
                    break;
                }
                case 3: {
                    this.printText(out, fstack, (Text)c);
                }
            }
        }
    }

    private void printNamespace(Writer out, FormatStack fstack, Namespace ns) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        this.write(out, " xmlns");
        if (!prefix.isEmpty()) {
            this.write(out, ":");
            this.write(out, prefix);
        }
        this.write(out, "=\"");
        this.attributeEscapedEntitiesFilter(out, fstack, uri);
        this.write(out, "\"");
    }

    private void printAttribute(Writer out, FormatStack fstack, Attribute attribute) throws IOException {
        this.write(out, " ");
        this.write(out, attribute.getQualifiedName());
        this.write(out, "=");
        this.write(out, "\"");
        this.attributeEscapedEntitiesFilter(out, fstack, attribute.getValue());
        this.write(out, "\"");
    }
}

