/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.protobuf.ProtoParsingException;
import org.openrewrite.protobuf.internal.ProtoParserVisitor;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Lexer;
import org.openrewrite.protobuf.internal.grammar.Protobuf2Parser;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class ProtoParser
implements Parser<Proto.Document> {
    public List<Proto.Document> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a Protobuf file").tag("file.type", "Proto");
            Timer.Sample sample = Timer.start();
            Path path = sourceFile.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                String sourceStr = is.readFully();
                Protobuf2Parser parser = new Protobuf2Parser((TokenStream)new CommonTokenStream((TokenSource)new Protobuf2Lexer((CharStream)CharStreams.fromString((String)sourceStr))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                if (sourceStr.contains("proto3")) {
                    return null;
                }
                Proto.Document document = new ProtoParserVisitor(path, sourceFile.getFileAttributes(), sourceStr, is.getCharset(), is.isCharsetBomMarked()).visitProto(parser.proto());
                sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                parsingListener.parsed(sourceFile, (SourceFile)document);
                return document;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ParsingExecutionContextView.view((ExecutionContext)ctx).parseFailure(sourceFile, relativeTo, (Parser)this, t);
                ctx.getOnError().accept(new IllegalStateException(path + " " + t.getMessage(), t));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Proto.Document> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".proto");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.proto");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Proto.Document.class);
        }

        public ProtoParser build() {
            return new ProtoParser();
        }

        public String getDslName() {
            return "proto";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new ProtoParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

