/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.io.Serializable;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

public final class ResolvedGroupArtifactVersion
implements Serializable {
    private final @Nullable String repository;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final @Nullable String datedSnapshotVersion;

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + (this.datedSnapshotVersion == null ? this.version : this.datedSnapshotVersion);
    }

    public GroupArtifact asGroupArtifact() {
        return new GroupArtifact(this.groupId, this.artifactId);
    }

    public GroupArtifactVersion asGroupArtifactVersion() {
        return new GroupArtifactVersion(this.groupId, this.artifactId, this.version);
    }

    public ResolvedGroupArtifactVersion withVersionMaybeSnapshot(String version) {
        String maybeSnapshotVersion;
        String datedSnapshotVersion;
        if (version.matches(".*-\\d{8}\\.\\d{6}-\\d+")) {
            datedSnapshotVersion = version;
            int dashIndex = version.indexOf(45);
            maybeSnapshotVersion = version.substring(0, dashIndex) + "-SNAPSHOT";
        } else {
            maybeSnapshotVersion = version;
            datedSnapshotVersion = null;
        }
        return new ResolvedGroupArtifactVersion(this.repository, this.groupId, this.artifactId, maybeSnapshotVersion, datedSnapshotVersion);
    }

    @Generated
    public ResolvedGroupArtifactVersion(@Nullable String repository, String groupId, String artifactId, String version, @Nullable String datedSnapshotVersion) {
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.datedSnapshotVersion = datedSnapshotVersion;
    }

    @Generated
    public @Nullable String getRepository() {
        return this.repository;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getDatedSnapshotVersion() {
        return this.datedSnapshotVersion;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedGroupArtifactVersion)) {
            return false;
        }
        ResolvedGroupArtifactVersion other = (ResolvedGroupArtifactVersion)o;
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$datedSnapshotVersion = this.getDatedSnapshotVersion();
        String other$datedSnapshotVersion = other.getDatedSnapshotVersion();
        return !(this$datedSnapshotVersion == null ? other$datedSnapshotVersion != null : !this$datedSnapshotVersion.equals(other$datedSnapshotVersion));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $datedSnapshotVersion = this.getDatedSnapshotVersion();
        result = result * 59 + ($datedSnapshotVersion == null ? 43 : $datedSnapshotVersion.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public ResolvedGroupArtifactVersion withRepository(@Nullable String repository) {
        return this.repository == repository ? this : new ResolvedGroupArtifactVersion(repository, this.groupId, this.artifactId, this.version, this.datedSnapshotVersion);
    }

    @NonNull
    @Generated
    public ResolvedGroupArtifactVersion withGroupId(String groupId) {
        return this.groupId == groupId ? this : new ResolvedGroupArtifactVersion(this.repository, groupId, this.artifactId, this.version, this.datedSnapshotVersion);
    }

    @NonNull
    @Generated
    public ResolvedGroupArtifactVersion withArtifactId(String artifactId) {
        return this.artifactId == artifactId ? this : new ResolvedGroupArtifactVersion(this.repository, this.groupId, artifactId, this.version, this.datedSnapshotVersion);
    }

    @NonNull
    @Generated
    public ResolvedGroupArtifactVersion withVersion(String version) {
        return this.version == version ? this : new ResolvedGroupArtifactVersion(this.repository, this.groupId, this.artifactId, version, this.datedSnapshotVersion);
    }

    @NonNull
    @Generated
    public ResolvedGroupArtifactVersion withDatedSnapshotVersion(@Nullable String datedSnapshotVersion) {
        return this.datedSnapshotVersion == datedSnapshotVersion ? this : new ResolvedGroupArtifactVersion(this.repository, this.groupId, this.artifactId, this.version, datedSnapshotVersion);
    }
}

