/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.xml.tree.Xml;
import org.opentest4j.AssertionFailedError;

public class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        boolean nothingConfigured;
        MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
        boolean bl = nothingConfigured = mctx.getSettings() == null && mctx.getLocalRepository().equals(MavenRepository.MAVEN_LOCAL_DEFAULT) && mctx.getRepositories().isEmpty() && mctx.getActiveProfiles().isEmpty() && mctx.getMirrors().isEmpty();
        if (nothingConfigured) {
            mctx.setMavenSettings(MavenSettings.readMavenSettingsFromDisk((ExecutionContext)mctx), new String[0]);
        }
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before) {
        return Assertions.pomXml(before, (SourceSpec<Xml.Document> s) -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after) {
        return Assertions.pomXml(before, after, s -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext).after(s -> after);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    private static SourceFile pomResolvedSuccessfully(SourceFile sourceFile, TypeValidation typeValidation) {
        if (typeValidation.dependencyModel()) {
            sourceFile.getMarkers().findFirst(ParseExceptionResult.class).ifPresent(parseExceptionResult -> org.junit.jupiter.api.Assertions.fail((String)("Problem parsing " + sourceFile.getSourcePath() + ":\n" + parseExceptionResult.getMessage())));
            sourceFile.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new AssertionFailedError("No MavenResolutionResult found on " + sourceFile.getSourcePath()));
        }
        return sourceFile;
    }
}

