/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.TagNameComparator;
import org.openrewrite.xml.tree.Xml;

public final class AddProperty
extends Recipe {
    @Option(displayName="Key", description="The name of the property key to be added.", example="junit.version")
    private final String key;
    @Option(displayName="Value", description="The value of property to be added.", example="4.13")
    private final String value;
    @Option(displayName="Preserve value if property exists", description="Preserve previous value if the property already exists in the pom file.", required=false, example="false")
    @Nullable
    private final Boolean preserveExistingValue;
    @Option(displayName="Trust parent POM", description="Even if the parent defines a property with the same key, trust it even if the value isn't the same. Useful when you want to wait for the parent to have its value changed first. The parent is not trusted by default.", example="false", required=false)
    @Nullable
    private final Boolean trustParent;

    public String getDisplayName() {
        return "Add Maven project property";
    }

    public String getDescription() {
        return "Add a new property to the Maven project property.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                String myValue;
                String currentValue = this.getResolutionResult().getPom().getProperties().get(AddProperty.this.key);
                boolean trust = Boolean.TRUE.equals(AddProperty.this.trustParent);
                if (!trust && !AddProperty.this.value.equals(currentValue)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                if (trust && (myValue = this.getResolutionResult().getPom().getRequested().getProperties().get(AddProperty.this.key)) != null && !myValue.equals(AddProperty.this.value)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                return document;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final String propertyName;
            {
                this.propertyName = AddProperty.this.key.replace("${", "").replace("}", "");
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                Xml.Tag root = d.getRoot();
                Optional properties = root.getChild("properties");
                if (!properties.isPresent()) {
                    Xml.Tag propertiesTag = Xml.Tag.build((String)("<properties>\n<" + this.propertyName + ">" + AddProperty.this.value + "</" + this.propertyName + ">\n</properties>"));
                    d = (Xml.Document)new AddToTagVisitor(root, propertiesTag, (Comparator)new MavenTagInsertionComparator(root.getChildren())).visitNonNull((Tree)d, (Object)ctx);
                } else if (!((Xml.Tag)properties.get()).getChildValue(this.propertyName).isPresent()) {
                    Xml.Tag propertyTag = Xml.Tag.build((String)("<" + this.propertyName + ">" + AddProperty.this.value + "</" + this.propertyName + ">"));
                    d = (Xml.Document)new AddToTagVisitor((Xml.Tag)properties.get(), propertyTag, (Comparator)new TagNameComparator()).visitNonNull((Tree)d, (Object)ctx);
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (!Boolean.TRUE.equals(AddProperty.this.preserveExistingValue) && this.isPropertyTag() && this.propertyName.equals(tag.getName()) && !AddProperty.this.value.equals(tag.getValue().orElse(null))) {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, AddProperty.this.value));
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    public AddProperty(String key, String value, @Nullable Boolean preserveExistingValue, @Nullable Boolean trustParent) {
        this.key = key;
        this.value = value;
        this.preserveExistingValue = preserveExistingValue;
        this.trustParent = trustParent;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public Boolean getPreserveExistingValue() {
        return this.preserveExistingValue;
    }

    @Nullable
    public Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    public String toString() {
        return "AddProperty(key=" + this.getKey() + ", value=" + this.getValue() + ", preserveExistingValue=" + this.getPreserveExistingValue() + ", trustParent=" + this.getTrustParent() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProperty)) {
            return false;
        }
        AddProperty other = (AddProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$preserveExistingValue = this.getPreserveExistingValue();
        Boolean other$preserveExistingValue = other.getPreserveExistingValue();
        if (this$preserveExistingValue == null ? other$preserveExistingValue != null : !((Object)this$preserveExistingValue).equals(other$preserveExistingValue)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $preserveExistingValue = this.getPreserveExistingValue();
        result = result * 59 + ($preserveExistingValue == null ? 43 : ((Object)$preserveExistingValue).hashCode());
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

