/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;

public class MavenResolutionResult
implements Marker {
    private UUID id;
    @Nullable
    private Integer managedReference;
    private ResolvedPom pom;
    private List<MavenResolutionResult> modules;
    @Nullable
    private MavenResolutionResult parent;
    private Map<Scope, List<ResolvedDependency>> dependencies;

    public MavenResolutionResult unsafeSetManagedReference(Integer id) {
        this.managedReference = id;
        return this;
    }

    @Nullable
    @Incubating(since="7.18.0")
    public ResolvedDependency getResolvedDependency(Dependency dependency) {
        for (int i = Scope.values().length - 1; i >= 0; --i) {
            Scope scope = Scope.values()[i];
            if (!this.dependencies.containsKey((Object)scope)) continue;
            for (ResolvedDependency resolvedDependency : this.dependencies.get((Object)scope)) {
                if (resolvedDependency.getRequested() != dependency) continue;
                return resolvedDependency;
            }
        }
        return null;
    }

    @Incubating(since="7.19.0")
    public List<ResolvedDependency> findDependencies(String groupId, String artifactId, @Nullable Scope scope) {
        return this.findDependencies(d -> StringUtils.matchesGlob((String)d.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)d.getArtifactId(), (String)artifactId), scope);
    }

    @Incubating(since="7.19.0")
    public List<ResolvedDependency> findDependencies(Predicate<ResolvedDependency> matcher, @Nullable Scope scope) {
        ArrayList<ResolvedDependency> found = null;
        for (Map.Entry<Scope, List<ResolvedDependency>> entry : this.dependencies.entrySet()) {
            if (scope != null && entry.getKey() != scope) continue;
            for (ResolvedDependency d : entry.getValue()) {
                if (!matcher.test(d)) continue;
                if (found == null) {
                    found = new ArrayList<ResolvedDependency>();
                }
                found.add(d);
            }
        }
        return found == null ? Collections.emptyList() : found;
    }

    public void unsafeSet(UUID id, ResolvedPom pom, List<MavenResolutionResult> modules, @Nullable MavenResolutionResult parent, Map<Scope, List<ResolvedDependency>> dependencies) {
        this.id = id;
        this.pom = pom;
        this.modules = modules;
        this.parent = parent;
        this.dependencies = dependencies;
    }

    public void unsafeSetParent(MavenResolutionResult parent) {
        this.parent = parent;
    }

    public void unsafeSetModules(List<MavenResolutionResult> modules) {
        this.modules = new ArrayList<MavenResolutionResult>(modules);
    }

    @Nullable
    @Incubating(since="7.18.0")
    public ResolvedManagedDependency getResolvedManagedDependency(ManagedDependency dependency) {
        for (ResolvedManagedDependency dm : this.pom.getDependencyManagement()) {
            if (dm.getRequested() != dependency && dm.getRequestedBom() != dependency) continue;
            return dm;
        }
        return null;
    }

    public MavenResolutionResult resolveDependencies(MavenPomDownloader downloader, ExecutionContext ctx) {
        HashMap<Scope, List<ResolvedDependency>> dependencies = new HashMap<Scope, List<ResolvedDependency>>();
        dependencies.put(Scope.Compile, this.pom.resolveDependencies(Scope.Compile, downloader, ctx));
        dependencies.put(Scope.Test, this.pom.resolveDependencies(Scope.Test, downloader, ctx));
        dependencies.put(Scope.Runtime, this.pom.resolveDependencies(Scope.Runtime, downloader, ctx));
        dependencies.put(Scope.Provided, this.pom.resolveDependencies(Scope.Provided, downloader, ctx));
        return this.withDependencies(dependencies);
    }

    public Map<Path, Pom> getProjectPoms() {
        return this.getProjectPomsRecursive(new HashMap<Path, Pom>());
    }

    private Map<Path, Pom> getProjectPomsRecursive(Map<Path, Pom> projectPoms) {
        projectPoms.put(this.pom.getRequested().getSourcePath(), this.pom.getRequested());
        if (this.parent != null) {
            this.parent.getProjectPomsRecursive(projectPoms);
        }
        for (MavenResolutionResult module : this.modules) {
            if (projectPoms.containsKey(module.getPom().getRequested().getSourcePath())) continue;
            module.getProjectPomsRecursive(projectPoms);
        }
        return projectPoms;
    }

    public MavenResolutionResult(UUID id, @Nullable Integer managedReference, ResolvedPom pom, List<MavenResolutionResult> modules, @Nullable MavenResolutionResult parent, Map<Scope, List<ResolvedDependency>> dependencies) {
        this.id = id;
        this.managedReference = managedReference;
        this.pom = pom;
        this.modules = modules;
        this.parent = parent;
        this.dependencies = dependencies;
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public Integer getManagedReference() {
        return this.managedReference;
    }

    public ResolvedPom getPom() {
        return this.pom;
    }

    public List<MavenResolutionResult> getModules() {
        return this.modules;
    }

    @Nullable
    public MavenResolutionResult getParent() {
        return this.parent;
    }

    public Map<Scope, List<ResolvedDependency>> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    public MavenResolutionResult withId(UUID id) {
        return this.id == id ? this : new MavenResolutionResult(id, this.managedReference, this.pom, this.modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withPom(ResolvedPom pom) {
        return this.pom == pom ? this : new MavenResolutionResult(this.id, this.managedReference, pom, this.modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withModules(List<MavenResolutionResult> modules) {
        return this.modules == modules ? this : new MavenResolutionResult(this.id, this.managedReference, this.pom, modules, this.parent, this.dependencies);
    }

    @NonNull
    public MavenResolutionResult withDependencies(Map<Scope, List<ResolvedDependency>> dependencies) {
        return this.dependencies == dependencies ? this : new MavenResolutionResult(this.id, this.managedReference, this.pom, this.modules, this.parent, dependencies);
    }
}

