/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String versionPattern;
    @Nullable
    private final String scope;
    @Nullable
    private final Boolean releasesOnly;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;
    @Nullable
    private final Boolean optional;
    @Nullable
    private final Pattern familyRegex;
    @Nullable
    private VersionComparator versionComparator;
    @Nullable
    private String resolvedVersion;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
        Xml.Tag root;
        Xml.Document maven = super.visitDocument(document, executionContext);
        Validated versionValidation = Semver.validate((String)this.version, (String)this.versionPattern);
        if (versionValidation.isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (!(root = maven.getRoot()).getChild("dependencies").isPresent()) {
            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencies/>"), (Comparator)new MavenTagInsertionComparator(root.getContent() == null ? Collections.emptyList() : root.getContent())));
        }
        this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder(this.scope));
        return maven;
    }

    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Pattern familyRegex) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.familyRegex = familyRegex;
    }

    private class InsertDependencyInOrder
    extends MavenVisitor<ExecutionContext> {
        @Nullable
        private final String scope;

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                String versionToUse = null;
                if (this.getResolutionResult().getPom().getManagedVersion(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, AddDependencyVisitor.this.type, AddDependencyVisitor.this.classifier) == null) {
                    if (AddDependencyVisitor.this.familyRegex != null) {
                        versionToUse = this.findDependencies(d -> AddDependencyVisitor.this.familyRegex.matcher(d.getGroupId()).matches()).stream().max(Comparator.comparing(d -> new Version(d.getVersion()))).map(d -> d.getRequested().getVersion()).orElse(null);
                    }
                    if (versionToUse == null) {
                        versionToUse = this.findVersionToUse(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, ctx);
                    }
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + AddDependencyVisitor.this.groupId + "</groupId>\n<artifactId>" + AddDependencyVisitor.this.artifactId + "</artifactId>\n" + (versionToUse == null ? "" : "<version>" + versionToUse + "</version>\n") + (AddDependencyVisitor.this.classifier == null ? "" : "<classifier>" + AddDependencyVisitor.this.classifier + "</classifier>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + (Boolean.TRUE.equals(AddDependencyVisitor.this.optional) ? "<optional>true</optional>\n" : "") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
                this.maybeUpdateModel();
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        private String findVersionToUse(String groupId, String artifactId, ExecutionContext ctx) {
            if (AddDependencyVisitor.this.resolvedVersion == null) {
                if (AddDependencyVisitor.this.versionComparator == null) {
                    AddDependencyVisitor.this.resolvedVersion = AddDependencyVisitor.this.version;
                } else {
                    MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, ctx);
                    LatestRelease latest = new LatestRelease(AddDependencyVisitor.this.versionPattern);
                    AddDependencyVisitor.this.resolvedVersion = mavenMetadata.getVersioning().getVersions().stream().filter(v -> AddDependencyVisitor.this.versionComparator.isValid(null, v)).filter(v -> !Boolean.TRUE.equals(AddDependencyVisitor.this.releasesOnly) || latest.isValid(null, v)).max((v1, v2) -> AddDependencyVisitor.this.versionComparator.compare(null, v1, v2)).orElse(AddDependencyVisitor.this.version);
                }
            }
            return AddDependencyVisitor.this.resolvedVersion;
        }

        public InsertDependencyInOrder(String scope) {
            this.scope = scope;
        }
    }
}

