/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.ai;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TokenCount;
import org.openrewrite.java.tree.J;

public final class MethodDefinitionLength
extends Recipe {
    private final transient TokenCount tokens = new TokenCount(this);

    public String getDisplayName() {
        return "Calculate token length of method definitions";
    }

    public String getDescription() {
        return "Locates method definitions and predicts the number of token in each.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J md = super.visitMethodDeclaration(method, ctx);
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd == null) {
                    return md;
                }
                int numberOfTokens = (int)((double)md.printTrimmed(this.getCursor()).length() / 3.5);
                MethodDefinitionLength.this.tokens.insertRow(ctx, new TokenCount.Row(((J.MethodDeclaration)md).getSimpleName(), numberOfTokens));
                return md;
            }
        };
    }

    @Generated
    public MethodDefinitionLength() {
    }

    @Generated
    public TokenCount getTokens() {
        return this.tokens;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MethodDefinitionLength(tokens=" + (Object)((Object)this.getTokens()) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDefinitionLength)) {
            return false;
        }
        MethodDefinitionLength other = (MethodDefinitionLength)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MethodDefinitionLength;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

