/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeMethodInvocationReturnType
extends Recipe {
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="org.mockito.Matchers anyVararg()")
    private final String methodPattern;
    @Option(displayName="New method invocation return type", description="The fully qualified new return type of method invocation.", example="long")
    private final String newReturnType;

    public String getDisplayName() {
        return "Change method invocation return type";
    }

    public String getDescription() {
        return "Changes the return type of a method invocation.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final MethodMatcher methodMatcher;
            private boolean methodUpdated;
            {
                this.methodMatcher = new MethodMatcher(ChangeMethodInvocationReturnType.this.methodPattern, false);
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                JavaType.Method type = ((J.MethodInvocation)m).getMethodType();
                if (this.methodMatcher.matches(method) && type != null && !ChangeMethodInvocationReturnType.this.newReturnType.equals(type.getReturnType().toString())) {
                    if (((J.MethodInvocation)(m = ((J.MethodInvocation)m).withMethodType(type = type.withReturnType(JavaType.buildType(ChangeMethodInvocationReturnType.this.newReturnType))))).getName().getType() != null) {
                        m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withType(type));
                    }
                    this.methodUpdated = true;
                }
                return m;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                this.methodUpdated = false;
                JavaType.FullyQualified originalType = multiVariable.getTypeAsFullyQualified();
                J mv = super.visitVariableDeclarations(multiVariable, ctx);
                if (this.methodUpdated) {
                    JavaType newType = JavaType.buildType(ChangeMethodInvocationReturnType.this.newReturnType);
                    JavaType.FullyQualified newFieldType = TypeUtils.asFullyQualified(newType);
                    this.maybeAddImport(newFieldType);
                    this.maybeRemoveImport(originalType);
                    mv = ((J.VariableDeclarations)mv).withTypeExpression(((J.VariableDeclarations)mv).getTypeExpression() == null ? null : new J.Identifier(((J.VariableDeclarations)mv).getTypeExpression().getId(), ((J.VariableDeclarations)mv).getTypeExpression().getPrefix(), Markers.EMPTY, Collections.emptyList(), ChangeMethodInvocationReturnType.this.newReturnType.substring(ChangeMethodInvocationReturnType.this.newReturnType.lastIndexOf(46) + 1), newType, null));
                    mv = ((J.VariableDeclarations)mv).withVariables(ListUtils.map(((J.VariableDeclarations)mv).getVariables(), var -> {
                        JavaType.FullyQualified varType = TypeUtils.asFullyQualified(var.getType());
                        if (varType != null && !varType.equals(newType)) {
                            return var.withType(newType).withName(var.getName().withType(newType));
                        }
                        return var;
                    }));
                }
                return mv;
            }
        };
    }

    @Generated
    public ChangeMethodInvocationReturnType(String methodPattern, String newReturnType) {
        this.methodPattern = methodPattern;
        this.newReturnType = newReturnType;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getNewReturnType() {
        return this.newReturnType;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeMethodInvocationReturnType(methodPattern=" + this.getMethodPattern() + ", newReturnType=" + this.getNewReturnType() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodInvocationReturnType)) {
            return false;
        }
        ChangeMethodInvocationReturnType other = (ChangeMethodInvocationReturnType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$newReturnType = this.getNewReturnType();
        String other$newReturnType = other.getNewReturnType();
        return !(this$newReturnType == null ? other$newReturnType != null : !this$newReturnType.equals(other$newReturnType));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodInvocationReturnType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $newReturnType = this.getNewReturnType();
        result = result * 59 + ($newReturnType == null ? 43 : $newReturnType.hashCode());
        return result;
    }
}

