/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.sizes;

import java.io.File;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractFileSetCheck;
import org.openrewrite.tools.checkstyle.api.FileText;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class LineLengthCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "maxLineLen";
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private static final Pattern IGNORE_PATTERN = Pattern.compile("^(package|import) .*");
    private int max = 80;
    private Pattern ignorePattern = Pattern.compile("^$");

    @Override
    protected void processFiltered(File file, FileText fileText) {
        for (int i = 0; i < fileText.size(); ++i) {
            String line = fileText.get(i);
            int realLength = CommonUtil.lengthExpandedTabs(line, line.codePointCount(0, line.length()), this.getTabWidth());
            if (realLength <= this.max || IGNORE_PATTERN.matcher(line).find() || this.ignorePattern.matcher(line).find()) continue;
            this.log(i + 1, MSG_KEY, this.max, realLength);
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public final void setIgnorePattern(Pattern pattern) {
        this.ignorePattern = pattern;
    }
}

