/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.javadoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.DetailNode;
import org.openrewrite.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import org.openrewrite.tools.checkstyle.utils.JavadocUtil;

@StatelessCheck
public class RequireEmptyLineBeforeBlockTagGroupCheck
extends AbstractJavadocCheck {
    public static final String MSG_JAVADOC_TAG_LINE_BEFORE = "javadoc.tag.line.before";
    private static final List<Integer> ONLY_TAG_VARIATION_1 = Arrays.asList(4, 1, 6);
    private static final List<Integer> ONLY_TAG_VARIATION_2 = Arrays.asList(1, 6);

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10071};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode tagNode) {
        if (!RequireEmptyLineBeforeBlockTagGroupCheck.isAnotherTagBefore(tagNode) && !RequireEmptyLineBeforeBlockTagGroupCheck.isOnlyTagInWholeJavadoc(tagNode) && RequireEmptyLineBeforeBlockTagGroupCheck.hasInsufficientConsecutiveNewlines(tagNode)) {
            this.log(tagNode.getLineNumber(), MSG_JAVADOC_TAG_LINE_BEFORE, tagNode.getChildren()[0].getText());
        }
    }

    private static boolean isAnotherTagBefore(DetailNode tagNode) {
        boolean found = false;
        DetailNode currentNode = JavadocUtil.getPreviousSibling(tagNode);
        while (currentNode != null) {
            if (currentNode.getType() == 10071) {
                found = true;
                break;
            }
            currentNode = JavadocUtil.getPreviousSibling(currentNode);
        }
        return found;
    }

    private static boolean isOnlyTagInWholeJavadoc(DetailNode tagNode) {
        ArrayList<Integer> previousNodeTypes = new ArrayList<Integer>();
        DetailNode currentNode = JavadocUtil.getPreviousSibling(tagNode);
        while (currentNode != null) {
            previousNodeTypes.add(currentNode.getType());
            currentNode = JavadocUtil.getPreviousSibling(currentNode);
        }
        return ONLY_TAG_VARIATION_1.equals(previousNodeTypes) || ONLY_TAG_VARIATION_2.equals(previousNodeTypes);
    }

    private static boolean hasInsufficientConsecutiveNewlines(DetailNode tagNode) {
        int count = 0;
        DetailNode currentNode = JavadocUtil.getPreviousSibling(tagNode);
        while (count <= 1 && currentNode != null && (currentNode.getType() == 6 || currentNode.getType() == 4 || currentNode.getType() == 1)) {
            if (currentNode.getType() == 6) {
                ++count;
            }
            currentNode = JavadocUtil.getPreviousSibling(currentNode);
        }
        return count <= 1;
    }
}

