/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.design;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public class InnerTypeLastCheck
extends AbstractCheck {
    public static final String MSG_KEY = "arrangement.members.before.inner";
    private static final List<Integer> CLASS_MEMBER_TOKENS = Arrays.asList(10, 9, 8, 11, 12, 203);
    private boolean rootClass = true;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 199};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.rootClass = true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.rootClass) {
            this.rootClass = false;
        } else {
            for (DetailAST nextSibling = ast.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (ScopeUtil.isInCodeBlock(ast) || !CLASS_MEMBER_TOKENS.contains(nextSibling.getType())) continue;
                this.log(nextSibling, MSG_KEY, new Object[0]);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isRootNode(ast.getParent())) {
            this.rootClass = true;
        }
    }
}

