/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openrewrite.tools.checkstyle.DefaultContext;
import org.openrewrite.tools.checkstyle.ModuleFactory;
import org.openrewrite.tools.checkstyle.PackageNamesLoader;
import org.openrewrite.tools.checkstyle.PackageObjectFactory;
import org.openrewrite.tools.checkstyle.PropertyCacheFile;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.AuditListener;
import org.openrewrite.tools.checkstyle.api.AutomaticBean;
import org.openrewrite.tools.checkstyle.api.BeforeExecutionFileFilter;
import org.openrewrite.tools.checkstyle.api.BeforeExecutionFileFilterSet;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.api.Configuration;
import org.openrewrite.tools.checkstyle.api.Context;
import org.openrewrite.tools.checkstyle.api.ExternalResourceHolder;
import org.openrewrite.tools.checkstyle.api.FileSetCheck;
import org.openrewrite.tools.checkstyle.api.FileText;
import org.openrewrite.tools.checkstyle.api.Filter;
import org.openrewrite.tools.checkstyle.api.FilterSet;
import org.openrewrite.tools.checkstyle.api.MessageDispatcher;
import org.openrewrite.tools.checkstyle.api.RootModule;
import org.openrewrite.tools.checkstyle.api.SeverityLevel;
import org.openrewrite.tools.checkstyle.api.SeverityLevelCounter;
import org.openrewrite.tools.checkstyle.api.Violation;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

public class Checker
extends AutomaticBean
implements MessageDispatcher,
RootModule {
    public static final String EXCEPTION_MSG = "general.exception";
    private final Log log;
    private final SeverityLevelCounter counter = new SeverityLevelCounter(SeverityLevel.ERROR);
    private final List<AuditListener> listeners = new ArrayList<AuditListener>();
    private final List<FileSetCheck> fileSetChecks = new ArrayList<FileSetCheck>();
    private final BeforeExecutionFileFilterSet beforeExecutionFileFilters = new BeforeExecutionFileFilterSet();
    private final FilterSet filters = new FilterSet();
    private String basedir;
    @XdocsPropertyType(value=PropertyType.LOCALE_COUNTRY)
    private String localeCountry = Locale.getDefault().getCountry();
    @XdocsPropertyType(value=PropertyType.LOCALE_LANGUAGE)
    private String localeLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory moduleFactory;
    private ClassLoader moduleClassLoader;
    private Context childContext;
    private String[] fileExtensions = CommonUtil.EMPTY_STRING_ARRAY;
    private SeverityLevel severity = SeverityLevel.ERROR;
    private String charset = StandardCharsets.UTF_8.name();
    @XdocsPropertyType(value=PropertyType.FILE)
    private PropertyCacheFile cacheFile;
    private boolean haltOnException = true;
    private int tabWidth = 8;

    public Checker() {
        this.addListener(this.counter);
        this.log = LogFactory.getLog(Checker.class);
    }

    public void setCacheFile(String fileName) throws IOException {
        Configuration configuration = this.getConfiguration();
        this.cacheFile = new PropertyCacheFile(configuration, fileName);
        this.cacheFile.load();
    }

    public void removeBeforeExecutionFileFilter(BeforeExecutionFileFilter filter) {
        this.beforeExecutionFileFilters.removeBeforeExecutionFileFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.removeFilter(filter);
    }

    @Override
    public void destroy() {
        this.listeners.clear();
        this.fileSetChecks.clear();
        this.beforeExecutionFileFilters.clear();
        this.filters.clear();
        if (this.cacheFile != null) {
            try {
                this.cacheFile.persist();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to persist cache file.", ex);
            }
        }
    }

    public void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    @Override
    public int process(List<File> files) throws CheckstyleException {
        if (this.cacheFile != null) {
            this.cacheFile.putExternalResources(this.getExternalResourceLocations());
        }
        this.fireAuditStarted();
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.beginProcessing(this.charset);
        }
        List<File> targetFiles = files.stream().filter(file -> CommonUtil.matchesFileExtension(file, this.fileExtensions)).collect(Collectors.toList());
        this.processFiles(targetFiles);
        this.fileSetChecks.forEach(FileSetCheck::finishProcessing);
        this.fileSetChecks.forEach(FileSetCheck::destroy);
        int errorCount = this.counter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    private Set<String> getExternalResourceLocations() {
        return Stream.concat(this.fileSetChecks.stream(), this.filters.getFilters().stream()).filter(ExternalResourceHolder.class::isInstance).map(ExternalResourceHolder.class::cast).flatMap(resource -> resource.getExternalResourceLocations().stream()).collect(Collectors.toSet());
    }

    private void fireAuditStarted() {
        AuditEvent event = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(event);
        }
    }

    private void fireAuditFinished() {
        AuditEvent event = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditFinished(event);
        }
    }

    private void processFiles(List<File> files) throws CheckstyleException {
        for (File file : files) {
            String fileName = null;
            try {
                fileName = file.getAbsolutePath();
                long timestamp = file.lastModified();
                if (this.cacheFile != null && this.cacheFile.isInCache(fileName, timestamp) || !this.acceptFileStarted(fileName)) continue;
                if (this.cacheFile != null) {
                    this.cacheFile.put(fileName, timestamp);
                }
                this.fireFileStarted(fileName);
                SortedSet<Violation> fileMessages = this.processFile(file);
                this.fireErrors(fileName, fileMessages);
                this.fireFileFinished(fileName);
            }
            catch (Exception ex) {
                if (fileName != null && this.cacheFile != null) {
                    this.cacheFile.remove(fileName);
                }
                throw new CheckstyleException("Exception was thrown while processing " + file.getPath(), ex);
            }
            catch (Error error) {
                if (fileName != null && this.cacheFile != null) {
                    this.cacheFile.remove(fileName);
                }
                throw new Error("Error was thrown while processing " + file.getPath(), error);
            }
        }
    }

    private SortedSet<Violation> processFile(File file) throws CheckstyleException {
        TreeSet<Violation> fileMessages = new TreeSet<Violation>();
        try {
            FileText theText = new FileText(file.getAbsoluteFile(), this.charset);
            for (FileSetCheck fsc : this.fileSetChecks) {
                fileMessages.addAll(fsc.process(file, theText));
            }
        }
        catch (IOException ioe) {
            this.log.debug((Object)"IOException occurred.", (Throwable)ioe);
            fileMessages.add(new Violation(1, "org.openrewrite.tools.checkstyle.messages", EXCEPTION_MSG, new String[]{ioe.getMessage()}, null, this.getClass(), null));
        }
        catch (Exception ex) {
            if (this.haltOnException) {
                throw ex;
            }
            this.log.debug((Object)"Exception occurred.", (Throwable)ex);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            fileMessages.add(new Violation(1, "org.openrewrite.tools.checkstyle.messages", EXCEPTION_MSG, new String[]{sw.getBuffer().toString()}, null, this.getClass(), null));
        }
        return fileMessages;
    }

    private boolean acceptFileStarted(String fileName) {
        String stripped = CommonUtil.relativizeAndNormalizePath(this.basedir, fileName);
        return this.beforeExecutionFileFilters.accept(stripped);
    }

    @Override
    public void fireFileStarted(String fileName) {
        String stripped = CommonUtil.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent event = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileStarted(event);
        }
    }

    @Override
    public void fireErrors(String fileName, SortedSet<Violation> errors) {
        String stripped = CommonUtil.relativizeAndNormalizePath(this.basedir, fileName);
        boolean hasNonFilteredViolations = false;
        for (Violation element : errors) {
            AuditEvent event = new AuditEvent(this, stripped, element);
            if (!this.filters.accept(event)) continue;
            hasNonFilteredViolations = true;
            for (AuditListener listener : this.listeners) {
                listener.addError(event);
            }
        }
        if (hasNonFilteredViolations && this.cacheFile != null) {
            this.cacheFile.remove(fileName);
        }
    }

    @Override
    public void fireFileFinished(String fileName) {
        String stripped = CommonUtil.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent event = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileFinished(event);
        }
    }

    @Override
    protected void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.localeLanguage, this.localeCountry);
        Violation.setLocale(locale);
        if (this.moduleFactory == null) {
            if (this.moduleClassLoader == null) {
                throw new CheckstyleException("if no custom moduleFactory is set, moduleClassLoader must be specified");
            }
            Set<String> packageNames = PackageNamesLoader.getPackageNames(this.moduleClassLoader);
            this.moduleFactory = new PackageObjectFactory(packageNames, this.moduleClassLoader);
        }
        DefaultContext context = new DefaultContext();
        context.add("charset", this.charset);
        context.add("moduleFactory", this.moduleFactory);
        context.add("severity", this.severity.getName());
        context.add("basedir", this.basedir);
        context.add("tabWidth", String.valueOf(this.tabWidth));
        this.childContext = context;
    }

    @Override
    protected void setupChild(Configuration childConf) throws CheckstyleException {
        Object filter;
        Object child;
        String name = childConf.getName();
        try {
            child = this.moduleFactory.createModule(name);
            if (child instanceof AutomaticBean) {
                AutomaticBean bean = (AutomaticBean)child;
                bean.contextualize(this.childContext);
                bean.configure(childConf);
            }
        }
        catch (CheckstyleException ex) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
        if (child instanceof FileSetCheck) {
            FileSetCheck fsc = (FileSetCheck)child;
            fsc.init();
            this.addFileSetCheck(fsc);
        } else if (child instanceof BeforeExecutionFileFilter) {
            filter = (BeforeExecutionFileFilter)child;
            this.addBeforeExecutionFileFilter((BeforeExecutionFileFilter)filter);
        } else if (child instanceof Filter) {
            filter = (Filter)child;
            this.addFilter((Filter)filter);
        } else if (child instanceof AuditListener) {
            AuditListener listener = (AuditListener)child;
            this.addListener(listener);
        } else {
            throw new CheckstyleException(name + " is not allowed as a child in Checker");
        }
    }

    public void addFileSetCheck(FileSetCheck fileSetCheck) {
        fileSetCheck.setMessageDispatcher(this);
        this.fileSetChecks.add(fileSetCheck);
    }

    public void addBeforeExecutionFileFilter(BeforeExecutionFileFilter filter) {
        this.beforeExecutionFileFilters.addBeforeExecutionFileFilter(filter);
    }

    public void addFilter(Filter filter) {
        this.filters.addFilter(filter);
    }

    @Override
    public final void addListener(AuditListener listener) {
        this.listeners.add(listener);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            this.fileExtensions = null;
        } else {
            this.fileExtensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                String extension = extensions[i];
                this.fileExtensions[i] = CommonUtil.startsWithChar(extension, '.') ? extension : "." + extension;
            }
        }
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setLocaleCountry(String localeCountry) {
        this.localeCountry = localeCountry;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    public final void setSeverity(String severity) {
        this.severity = SeverityLevel.getInstance(severity);
    }

    @Override
    public final void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }

    public void setHaltOnException(boolean haltOnException) {
        this.haltOnException = haltOnException;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void clearCache() {
        if (this.cacheFile != null) {
            this.cacheFile.reset();
        }
    }
}

