/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Comparator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;

public abstract class CoordinateBuilder {
    J tree;

    CoordinateBuilder(J tree) {
        this.tree = tree;
    }

    JavaCoordinates before(Space.Location location) {
        return new JavaCoordinates(this.tree, location, JavaCoordinates.Mode.BEFORE, null);
    }

    JavaCoordinates after(Space.Location location) {
        return new JavaCoordinates(this.tree, location, JavaCoordinates.Mode.AFTER, null);
    }

    JavaCoordinates replace(Space.Location location) {
        return new JavaCoordinates(this.tree, location, JavaCoordinates.Mode.REPLACEMENT, null);
    }

    public static class Yield
    extends Statement {
        Yield(J.Yield tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(Space.Location.YIELD_PREFIX);
        }
    }

    public static class VariableDeclarations
    extends Statement {
        VariableDeclarations(J.VariableDeclarations tree) {
            super(tree);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.BEFORE, idealOrdering);
        }
    }

    public static class Package
    extends Statement {
        Package(J.Package tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(Space.Location.PACKAGE_PREFIX);
        }
    }

    public static class Unary
    extends Statement {
        Unary(J.Unary tree) {
            super(tree);
        }

        @Override
        JavaCoordinates after(Space.Location location) {
            return this.after(this.isModifying() ? Space.Location.STATEMENT_PREFIX : Space.Location.EXPRESSION_PREFIX);
        }

        @Override
        public JavaCoordinates before() {
            return this.before(this.isModifying() ? Space.Location.STATEMENT_PREFIX : Space.Location.EXPRESSION_PREFIX);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(this.isModifying() ? Space.Location.STATEMENT_PREFIX : Space.Location.EXPRESSION_PREFIX);
        }

        private boolean isModifying() {
            return ((J.Unary)this.tree).getOperator().isModifying();
        }
    }

    public static class MethodInvocation
    extends Statement {
        MethodInvocation(J.MethodInvocation tree) {
            super(tree);
        }

        public JavaCoordinates replaceArguments() {
            return this.replace(Space.Location.METHOD_INVOCATION_ARGUMENTS);
        }

        public JavaCoordinates replaceMethod() {
            return this.replace(Space.Location.METHOD_INVOCATION_NAME);
        }
    }

    public static class MethodDeclaration
    extends Statement {
        MethodDeclaration(J.MethodDeclaration tree) {
            super(tree);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.BEFORE, idealOrdering);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public JavaCoordinates replaceTypeParameters() {
            return this.replace(Space.Location.TYPE_PARAMETERS);
        }

        public JavaCoordinates replaceParameters() {
            return this.replace(Space.Location.METHOD_DECLARATION_PARAMETERS);
        }

        public JavaCoordinates replaceThrows() {
            return this.replace(Space.Location.THROWS);
        }

        public JavaCoordinates replaceBody() {
            return this.replace(Space.Location.BLOCK_PREFIX);
        }
    }

    public static class Lambda {

        public static class Parameters
        extends CoordinateBuilder {
            Parameters(J.Lambda.Parameters tree) {
                super(tree);
            }

            public JavaCoordinates replace() {
                return this.replace(Space.Location.LAMBDA_PARAMETERS_PREFIX);
            }
        }
    }

    public static class Identifier
    extends Expression {
        public Identifier(J.Identifier tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(Space.Location.IDENTIFIER_PREFIX);
        }
    }

    public static class FieldAccess
    extends CoordinateBuilder {
        public FieldAccess(J.FieldAccess tree) {
            super(tree);
        }

        public JavaCoordinates replace() {
            return this.replace(Space.Location.FIELD_ACCESS_PREFIX);
        }
    }

    public static class ClassDeclaration
    extends Statement {
        ClassDeclaration(J.ClassDeclaration tree) {
            super(tree);
        }

        public JavaCoordinates addAnnotation(Comparator<J.Annotation> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.ANNOTATIONS, JavaCoordinates.Mode.BEFORE, idealOrdering);
        }

        public JavaCoordinates replaceAnnotations() {
            return this.replace(Space.Location.ANNOTATIONS);
        }

        public JavaCoordinates replaceTypeParameters() {
            return this.replace(Space.Location.TYPE_PARAMETERS);
        }

        public JavaCoordinates replaceExtendsClause() {
            return this.replace(Space.Location.EXTENDS);
        }

        public JavaCoordinates replaceImplementsClause() {
            return this.replace(Space.Location.IMPLEMENTS);
        }

        public JavaCoordinates addImplementsClause() {
            return new JavaCoordinates(this.tree, Space.Location.IMPLEMENTS, JavaCoordinates.Mode.AFTER, null);
        }
    }

    public static class Block
    extends Statement {
        Block(J.Block tree) {
            super(tree);
        }

        public JavaCoordinates firstStatement() {
            if (((J.Block)this.tree).getStatements().isEmpty()) {
                return this.lastStatement();
            }
            return ((J.Block)this.tree).getStatements().get(0).getCoordinates().before();
        }

        public JavaCoordinates addStatement(Comparator<org.openrewrite.java.tree.Statement> idealOrdering) {
            return new JavaCoordinates(this.tree, Space.Location.BLOCK_END, JavaCoordinates.Mode.BEFORE, idealOrdering);
        }

        public JavaCoordinates addMethodDeclaration(Comparator<J.MethodDeclaration> idealOrdering) {
            Comparator natural = Comparator.naturalOrder();
            return this.addStatement((s1, s2) -> s1 instanceof J.MethodDeclaration && s2 instanceof J.MethodDeclaration ? idealOrdering.compare((J.MethodDeclaration)s1, (J.MethodDeclaration)s2) : natural.compare(s1.getId(), s2.getId()));
        }

        public JavaCoordinates lastStatement() {
            return this.before(Space.Location.BLOCK_END);
        }
    }

    public static class Annotation
    extends Expression {
        Annotation(J.Annotation tree) {
            super(tree);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(Space.Location.ANNOTATION_PREFIX);
        }

        public JavaCoordinates replaceArguments() {
            return this.replace(Space.Location.ANNOTATION_ARGUMENTS);
        }
    }

    public static class Expression
    extends CoordinateBuilder {
        public Expression(J tree) {
            super(tree);
        }

        public JavaCoordinates replace() {
            return this.replace(Space.Location.EXPRESSION_PREFIX);
        }
    }

    public static class Statement
    extends Expression {
        public Statement(org.openrewrite.java.tree.Statement tree) {
            super(tree);
        }

        public JavaCoordinates after() {
            return this.after(Space.Location.STATEMENT_PREFIX);
        }

        public JavaCoordinates before() {
            return this.before(Space.Location.STATEMENT_PREFIX);
        }

        @Override
        public JavaCoordinates replace() {
            return this.replace(Space.Location.STATEMENT_PREFIX);
        }
    }
}

