/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindImplementations
extends Recipe {
    @Option(displayName="Type name", description="The fully qualified name to search for.", example="org.openrewrite.Recipe")
    private final String typeName;

    public String getDisplayName() {
        return "Find implementing classes";
    }

    public String getDescription() {
        return "Find class declarations which implement the specified type. If the specified type is a class, its subclasses will be matched. If the specified type is an interface, classes which implement it will be matched.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (TypeUtils.isAssignableTo(FindImplementations.this.typeName, (JavaType)((J.ClassDeclaration)cd).getType()) && !TypeUtils.isOfClassType(((J.ClassDeclaration)cd).getType(), FindImplementations.this.typeName)) {
                    cd = (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        };
    }

    @Generated
    public FindImplementations(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindImplementations(typeName=" + this.getTypeName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImplementations)) {
            return false;
        }
        FindImplementations other = (FindImplementations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindImplementations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }
}

