/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

final class JavaKeywordUtils {
    private static final String[] RESERVED_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String[] RESERVED_IDENTIFIERS = new String[]{"exports", "module", "non-sealed", "open", "opens", "permits", "provides", "record", "requires", "sealed", "to", "transitive", "uses", "var", "when", "with", "yield"};
    private static final String[] RESERVED_LITERALS = new String[]{"true", "false", "null"};
    private static final Set<String> RESERVED_KEYWORDS_SET = new HashSet<String>(Arrays.asList(RESERVED_KEYWORDS));
    private static final Set<String> RESERVED_IDENTIFIERS_SET = new HashSet<String>(Arrays.asList(RESERVED_IDENTIFIERS));
    private static final Set<String> RESERVED_LITERALS_SET = new HashSet<String>(Arrays.asList(RESERVED_LITERALS));

    static boolean isReservedKeyword(String word) {
        return RESERVED_KEYWORDS_SET.contains(word);
    }

    static boolean isReservedIdentifier(String word) {
        return RESERVED_IDENTIFIERS_SET.contains(word);
    }

    static boolean isReservedLiteral(String word) {
        return RESERVED_LITERALS_SET.contains(word);
    }

    @Generated
    private JavaKeywordUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

