/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.openrewrite.tools.checkstyle.PackageObjectFactory;
import org.openrewrite.tools.checkstyle.XpathFileGeneratorAstFilter;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.AuditListener;
import org.openrewrite.tools.checkstyle.api.AutomaticBean;

public class XpathFileGeneratorAuditListener
extends AutomaticBean
implements AuditListener {
    private static final String QUOTE_CHAR = "\"";
    private final PrintWriter writer;
    private final boolean closeStream;
    private boolean isXmlHeaderPrinted;

    public XpathFileGeneratorAuditListener(OutputStream out, AutomaticBean.OutputStreamOptions outputStreamOptions) {
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
    }

    @Override
    public void auditStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
        if (this.isXmlHeaderPrinted) {
            this.writer.println("</suppressions>");
        }
        this.writer.flush();
        if (this.closeStream) {
            this.writer.close();
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    @Override
    public void addError(AuditEvent event) {
        String xpathQuery = XpathFileGeneratorAstFilter.findCorrespondingXpathQuery(event);
        if (xpathQuery != null) {
            this.printXmlHeader();
            File file = new File(event.getFileName());
            this.writer.println("<suppress-xpath");
            this.writer.print("       files=\"");
            this.writer.print(file.getName());
            this.writer.println(QUOTE_CHAR);
            if (event.getModuleId() == null) {
                String checkName = PackageObjectFactory.getShortFromFullModuleNames(event.getSourceName());
                this.writer.print("       checks=\"");
                this.writer.print(checkName);
            } else {
                this.writer.print("       id=\"");
                this.writer.print(event.getModuleId());
            }
            this.writer.println(QUOTE_CHAR);
            this.writer.print("       query=\"");
            this.writer.print(xpathQuery);
            this.writer.println("\"/>");
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    private void printXmlHeader() {
        if (!this.isXmlHeaderPrinted) {
            this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.println("<!DOCTYPE suppressions PUBLIC");
            this.writer.println("    \"-//Checkstyle//DTD SuppressionXpathFilter Experimental Configuration 1.2//EN\"");
            this.writer.println("    \"https://checkstyle.org/dtds/suppressions_1_2_xpath_experimental.dtd\">");
            this.writer.println("<suppressions>");
            this.isXmlHeaderPrinted = true;
        }
    }

    @Override
    protected void finishLocalSetup() {
    }
}

