/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.LineEndingsCount;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;

public class AutodetectGeneralFormatStyle
extends JavaIsoVisitor<LineEndingsCount> {
    public static GeneralFormatStyle autodetectGeneralFormatStyle(JavaSourceFile j) {
        LineEndingsCount count = new LineEndingsCount();
        new AutodetectGeneralFormatStyle().visit(j, count);
        if (count.lf >= count.crlf) {
            return new GeneralFormatStyle(false);
        }
        return new GeneralFormatStyle(true);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, LineEndingsCount count) {
        String s = space.getWhitespace();
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            char next = '\u0000';
            if (i < s.length() - 1) {
                next = s.charAt(i + 1);
            }
            if (current == '\r' && next == '\n') {
                ++count.crlf;
                ++i;
                continue;
            }
            if (current != '\n') continue;
            ++count.lf;
        }
        return super.visitSpace(space, loc, count);
    }
}

