/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class RemoveUnusedImports
extends Recipe {
    public String getDisplayName() {
        return "Remove unused imports";
    }

    public String getDescription() {
        return "Remove imports for types that are not referenced.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1128");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new NoMissingTypes(), (TreeVisitor)new RemoveUnusedImportsVisitor());
    }

    private static String packageKey(String packageName, String className) {
        return className.contains(".") ? packageName + "." + className.substring(0, className.lastIndexOf(46)) : packageName;
    }

    private static class RemoveUnusedImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveUnusedImportsVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.Import elem;
            Object fq;
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            String sourcePackage = ((J.CompilationUnit)cu).getPackageDeclaration() == null ? "" : ((J.CompilationUnit)cu).getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            HashMap<String, TreeSet> methodsAndFieldsByTypeName = new HashMap<String, TreeSet>();
            HashMap typesByPackage = new HashMap();
            for (JavaType.Method method : ((J.CompilationUnit)cu).getTypesInUse().getUsedMethods()) {
                if (!method.hasFlags(Flag.Static)) continue;
                methodsAndFieldsByTypeName.computeIfAbsent(method.getDeclaringType().getFullyQualifiedName(), t -> new TreeSet()).add(method.getName());
            }
            for (JavaType.Variable variable : ((J.CompilationUnit)cu).getTypesInUse().getVariables()) {
                fq = TypeUtils.asFullyQualified(variable.getOwner());
                if (fq == null) continue;
                methodsAndFieldsByTypeName.computeIfAbsent(((JavaType.FullyQualified)fq).getFullyQualifiedName(), f -> new TreeSet()).add(variable.getName());
            }
            for (JavaType javaType : ((J.CompilationUnit)cu).getTypesInUse().getTypesInUse()) {
                if (javaType instanceof JavaType.Parameterized) {
                    JavaType.Parameterized parameterized = (JavaType.Parameterized)javaType;
                    typesByPackage.computeIfAbsent(parameterized.getType().getPackageName(), f -> new HashSet()).add(parameterized.getType());
                    for (JavaType typeParameter : parameterized.getTypeParameters()) {
                        JavaType.FullyQualified fq2 = TypeUtils.asFullyQualified(typeParameter);
                        if (fq2 == null) continue;
                        typesByPackage.computeIfAbsent(fq2.getPackageName(), f -> new HashSet()).add(fq2);
                    }
                    continue;
                }
                if (!(javaType instanceof JavaType.FullyQualified)) continue;
                fq = (JavaType.FullyQualified)javaType;
                typesByPackage.computeIfAbsent(((JavaType.FullyQualified)fq).getPackageName(), f -> new HashSet()).add(fq);
            }
            boolean changed = false;
            ArrayList<ImportUsage> importUsage = new ArrayList<ImportUsage>(((J.CompilationUnit)cu).getPadding().getImports().size());
            for (JRightPadded jRightPadded : ((J.CompilationUnit)cu).getPadding().getImports()) {
                ImportUsage singleUsage = new ImportUsage();
                singleUsage.imports.add(jRightPadded);
                importUsage.add(singleUsage);
            }
            HashSet<String> checkedImports = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> usedStaticWildcardImports = new HashSet<String>();
            for (ImportUsage anImport : importUsage) {
                elem = anImport.imports.get(0).getElement();
                J.FieldAccess qualid = elem.getQualid();
                J.Identifier name = qualid.getName();
                if (checkedImports.contains(elem.toString())) {
                    anImport.used = false;
                    changed = true;
                } else if (elem.isStatic()) {
                    String outerType = elem.getTypeName();
                    SortedSet methodsAndFields = (SortedSet)methodsAndFieldsByTypeName.get(outerType);
                    String target = qualid.getTarget().toString();
                    String modifiedTarget = methodsAndFieldsByTypeName.keySet().stream().filter(key -> key.matches(target.replaceAll("\\.", "(\\\\\\.|\\\\\\$)"))).findFirst().orElse(target);
                    SortedSet targetMethodsAndFields = (SortedSet)methodsAndFieldsByTypeName.get(modifiedTarget);
                    HashSet<JavaType.FullyQualified> staticClasses = null;
                    for (JavaType.FullyQualified maybeStatic : typesByPackage.getOrDefault(elem.getPackageName(), Collections.emptySet())) {
                        if (maybeStatic.getOwningClass() == null || !outerType.startsWith(maybeStatic.getOwningClass().getFullyQualifiedName())) continue;
                        if (staticClasses == null) {
                            staticClasses = new HashSet<JavaType.FullyQualified>();
                        }
                        staticClasses.add(maybeStatic);
                    }
                    if (methodsAndFields == null && targetMethodsAndFields == null && staticClasses == null) {
                        anImport.used = false;
                        changed = true;
                    } else if ("*".equals(qualid.getSimpleName())) {
                        if (ImportLayoutStyle.isPackageAlwaysFolded(layoutStyle.getPackagesToFold(), elem)) {
                            anImport.used = true;
                            usedStaticWildcardImports.add(elem.getTypeName());
                        } else if ((methodsAndFields == null ? 0 : methodsAndFields.size()) + (staticClasses == null ? 0 : staticClasses.size()) < layoutStyle.getNameCountToUseStarImport()) {
                            anImport.imports.clear();
                            if (methodsAndFields != null) {
                                for (String method : methodsAndFields) {
                                    anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName(method))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY));
                                }
                            }
                            if (staticClasses != null) {
                                for (JavaType.FullyQualified fqn : staticClasses) {
                                    anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName(fqn.getClassName().contains(".") ? fqn.getClassName().substring(fqn.getClassName().lastIndexOf(".") + 1) : fqn.getClassName()))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY));
                                }
                            }
                            anImport.imports.set(0, anImport.imports.get(0).withElement(anImport.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                            changed = true;
                        } else {
                            usedStaticWildcardImports.add(elem.getTypeName());
                        }
                    } else if (staticClasses != null && staticClasses.stream().anyMatch(c -> elem.getTypeName().equals(c.getFullyQualifiedName())) || methodsAndFields != null && methodsAndFields.contains(qualid.getSimpleName()) || targetMethodsAndFields != null && targetMethodsAndFields.contains(qualid.getSimpleName())) {
                        anImport.used = true;
                    } else {
                        anImport.used = false;
                        changed = true;
                    }
                } else {
                    Set types = (Set)typesByPackage.get(elem.getPackageName());
                    JavaType.FullyQualified qualidType = TypeUtils.asFullyQualified(elem.getQualid().getType());
                    if (types == null || sourcePackage.equals(elem.getPackageName()) && qualidType != null && !qualidType.getFullyQualifiedName().contains("$")) {
                        anImport.used = false;
                        changed = true;
                    } else if ("*".equals(elem.getQualid().getSimpleName())) {
                        if (ImportLayoutStyle.isPackageAlwaysFolded(layoutStyle.getPackagesToFold(), elem)) {
                            anImport.used = true;
                            hashSet.add(elem.getPackageName());
                        } else if (types.size() < layoutStyle.getClassCountToUseStarImport()) {
                            anImport.imports.clear();
                            types.stream().map(JavaType.FullyQualified::getClassName).sorted().distinct().forEach(type -> anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName((String)type))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY)));
                            anImport.imports.set(0, anImport.imports.get(0).withElement(anImport.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                            changed = true;
                        } else {
                            hashSet.add(elem.getPackageName());
                        }
                    } else if (types.stream().noneMatch(c -> {
                        if ("*".equals(elem.getQualid().getSimpleName())) {
                            return elem.getPackageName().equals(c.getPackageName());
                        }
                        return elem.getTypeName().equals(c.getFullyQualifiedName());
                    })) {
                        anImport.used = false;
                        changed = true;
                    }
                }
                checkedImports.add(elem.toString());
            }
            for (ImportUsage anImport : importUsage) {
                elem = anImport.imports.get(0).getElement();
                if ("*".equals(elem.getQualid().getSimpleName())) continue;
                if (elem.isStatic()) {
                    if (!usedStaticWildcardImports.contains(elem.getTypeName())) continue;
                    anImport.used = false;
                    changed = true;
                    continue;
                }
                if (hashSet.size() != 1 || !hashSet.contains(elem.getPackageName()) || elem.getTypeName().contains("$")) continue;
                anImport.used = false;
                changed = true;
            }
            if (changed) {
                ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
                Space lastUnusedImportSpace = null;
                for (ImportUsage anImportGroup : importUsage) {
                    if (anImportGroup.used) {
                        List<JRightPadded<J.Import>> importGroup = anImportGroup.imports;
                        for (int i = 0; i < importGroup.size(); ++i) {
                            JRightPadded<J.Import> anImport = importGroup.get(i);
                            if (i == 0 && lastUnusedImportSpace != null && anImport.getElement().getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() <= 1L) {
                                anImport = anImport.withElement(anImport.getElement().withPrefix(lastUnusedImportSpace));
                            }
                            imports.add(anImport);
                        }
                        lastUnusedImportSpace = null;
                        continue;
                    }
                    if (lastUnusedImportSpace != null) continue;
                    lastUnusedImportSpace = anImportGroup.imports.get(0).getElement().getPrefix();
                }
                if (((J.CompilationUnit)(cu = ((J.CompilationUnit)cu).getPadding().withImports(imports))).getImports().isEmpty() && !((J.CompilationUnit)cu).getClasses().isEmpty()) {
                    cu = (J.CompilationUnit)this.autoFormat(cu, ((J.CompilationUnit)cu).getClasses().get(0).getName(), ctx, this.getCursor().getParentOrThrow());
                }
            }
            return cu;
        }
    }

    private static class ImportUsage {
        final List<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
        boolean used = true;

        private ImportUsage() {
        }
    }
}

