/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.recipes.UpdateMovedPackageClassName;
import org.openrewrite.java.recipes.UpdateMovedRecipesYaml;

public final class UpdateMovedRecipe
extends Recipe {
    @Option(displayName="The fully qualified className of recipe moved from", description="The fully qualified className of recipe moved from a old package.", example="org.openrewrite.java.cleanup.UnnecessaryCatch")
    private final String oldRecipeFullyQualifiedClassName;
    @Option(displayName="The fully qualified className of recipe moved to", description="The fully qualified className of recipe moved to a new package.", example="org.openrewrite.staticanalysis.UnnecessaryCatch")
    private final String newRecipeFullyQualifiedClassName;

    public String getDisplayName() {
        return "Update moved package recipe";
    }

    public String getDescription() {
        return "Update moved package recipe.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new UpdateMovedPackageClassName(this.oldRecipeFullyQualifiedClassName, this.newRecipeFullyQualifiedClassName), new UpdateMovedRecipesYaml(this.oldRecipeFullyQualifiedClassName, this.newRecipeFullyQualifiedClassName)});
    }

    public UpdateMovedRecipe(String oldRecipeFullyQualifiedClassName, String newRecipeFullyQualifiedClassName) {
        this.oldRecipeFullyQualifiedClassName = oldRecipeFullyQualifiedClassName;
        this.newRecipeFullyQualifiedClassName = newRecipeFullyQualifiedClassName;
    }

    public String getOldRecipeFullyQualifiedClassName() {
        return this.oldRecipeFullyQualifiedClassName;
    }

    public String getNewRecipeFullyQualifiedClassName() {
        return this.newRecipeFullyQualifiedClassName;
    }

    @NonNull
    public String toString() {
        return "UpdateMovedRecipe(oldRecipeFullyQualifiedClassName=" + this.getOldRecipeFullyQualifiedClassName() + ", newRecipeFullyQualifiedClassName=" + this.getNewRecipeFullyQualifiedClassName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMovedRecipe)) {
            return false;
        }
        UpdateMovedRecipe other = (UpdateMovedRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        String other$oldRecipeFullyQualifiedClassName = other.getOldRecipeFullyQualifiedClassName();
        if (this$oldRecipeFullyQualifiedClassName == null ? other$oldRecipeFullyQualifiedClassName != null : !this$oldRecipeFullyQualifiedClassName.equals(other$oldRecipeFullyQualifiedClassName)) {
            return false;
        }
        String this$newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        String other$newRecipeFullyQualifiedClassName = other.getNewRecipeFullyQualifiedClassName();
        return !(this$newRecipeFullyQualifiedClassName == null ? other$newRecipeFullyQualifiedClassName != null : !this$newRecipeFullyQualifiedClassName.equals(other$newRecipeFullyQualifiedClassName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMovedRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        result = result * 59 + ($oldRecipeFullyQualifiedClassName == null ? 43 : $oldRecipeFullyQualifiedClassName.hashCode());
        String $newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        result = result * 59 + ($newRecipeFullyQualifiedClassName == null ? 43 : $newRecipeFullyQualifiedClassName.hashCode());
        return result;
    }
}

